using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Controls;

using MVVM;

using sdkdef = YoseenPTZ.SDKDef;
using YoseenPTZ.ConfigDef;
using YoseenPTZ.CoreDef;
using YoseenPTZ.ViewDef;

namespace YoseenPTZ
{
    public partial class ShellView : Window
    {
        readonly ConfigService _configService;
        readonly ClsHead _clsHead;
        readonly ClsDeviceConfig _clsDeviceConfig;
        readonly ClsImageConfig _clsImageConfig;
        public ShellView()
        {
            MaterialDesignWindow.RegisterCommands(this);
            InitializeComponent();

            int ret;
            _configService = App.Instance.ConfigService;
            _clsHead = _configService._clsHead;
            _clsDeviceConfig = _configService._clsDeviceConfig;
            _clsImageConfig = _configService._clsImageConfig;

            //
            deviceView.SetDeviceConfig(_clsDeviceConfig);
            deviceView.IRSetImageConfig(_clsImageConfig);
            ret =deviceView.PresetOpenConfig(AppStatic.FilePresetConfig);
            ptzView.SetDeviceView(deviceView);
        }

        #region play-pause-stop, save
        private void btnPlay_Click(object sender, RoutedEventArgs e)
        {
            int ret;
            ret=deviceView.StartPreview(true, _clsHead.IR_TempStream);
        }

        private void btnStop_Click(object sender, RoutedEventArgs e)
        {
            int ret;
            ret=deviceView.StopPreview(true);
        }

        private void btnEnableMouseMeasure_Click(object sender, RoutedEventArgs e)
        {
            bool? isChecked = btnEnableMouseMeasure.IsChecked;
            bool b = false;
            if (isChecked.HasValue && isChecked.Value)
            {
                b = true;
            }
            deviceView.Config_EnableMouse(b);
        }

        sdkdef.Ctl _ctl;
        private void btnFFC_Click(object sender, RoutedEventArgs e)
        {
            int ret;
            _ctl.Type = sdkdef.CtlType.CtlType_ManualFFC ;
            ret = deviceView.IRSendControl(ref _ctl);
        }

        private void btnSaveJpg_Click(object sender, RoutedEventArgs e)
        {
            DateTime dt = DateTime.Now;
            string dir = _clsHead.Data_SaveDir;
            string fnBase = string.Format("{0}\\{1:yyyyMMdd_HHmmss}", dir, dt);

            //
            int ret;
            ret = deviceView.BeginSave(fnBase, (int)sdkdef.EFileType.EFileType_jpg);
            txtEcho.Text = string.Format("截图, {0}, {1}", fnBase, ret);
        }

        bool _savingStream;
        string _savingStreamFilename;
        private void btnSaveStream_Click(object sender, RoutedEventArgs e)
        {
            if (_savingStream)
            {
                deviceView.EndSave();
                btnSaveStream.IsChecked = false;
                _savingStream = false;
                txtEcho.Text = string.Format("保存结束, {0}", _savingStreamFilename);
            }
            else
            {
                DateTime dt = DateTime.Now;
                string dir = _clsHead.Data_SaveDir;
                _savingStreamFilename = string.Format("{0}\\{1:yyyyMMdd_HHmmss}", dir, dt);
                int ret = deviceView.BeginSave(_savingStreamFilename, (int)sdkdef.EFileType.EFileType_stream);
                if (0 == ret)
                {
                    btnSaveStream.IsChecked = true;
                    _savingStream = true;
                }
                txtEcho.Text = string.Format("保存开始, {0}, {1}", _savingStreamFilename, ret);
            }
        }

        bool _savingMp4;
        string _savingMp4Filename;
        private void btnSaveMp4_Click(object sender, RoutedEventArgs e)
        {
            if (_savingMp4)
            {
                deviceView.EndSave();
                btnSaveMp4.IsChecked = false;
                _savingMp4 = false;
                txtEcho.Text = string.Format("保存结束, {0}", _savingMp4Filename);
            }
            else
            {
                DateTime dt = DateTime.Now;
                string dir = _clsHead.Data_SaveDir;
                _savingMp4Filename = string.Format("{0}\\{1:yyyyMMdd_HHmmss}", dir, dt);
                int ret = deviceView.BeginSave(_savingMp4Filename, (int)sdkdef.EFileType.EFileType_mp4);
                btnSaveMp4.IsChecked = true;
                _savingMp4 = true;
                txtEcho.Text = string.Format("保存开始, {0}, {1}", _savingMp4Filename, ret);
            }
        }
        #endregion

        #region config
        void funcAfterChange()
        {
            deviceView.IRSetImageConfig(_clsImageConfig);
        }
        private void btnConfigSystem_Click(object sender, RoutedEventArgs e)
        {
            ConfigSystemView view = ConfigSystemView.Instance;
            view.ShowConfig(funcAfterChange);
        }

        private void btnDiscoverCameras_Click(object sender, RoutedEventArgs e)
        {
            btnDiscoverCameras.IsEnabled = false;
            Task task = Task.Factory.StartNew(() =>
            {
                sdkdef.DiscoverCameraResp2[] irs = sdkdef.YoseenSDK.Yoseen_DiscoverCameras2(5);
                string[] viss = sdkdef.LibHK.DiscoverDevices();

                string s = "";
                int i;
                for (i = 0; i < irs.Length; i++)
                {
                    s += string.Format("ir {0}, {1}\n", sdkdef.YoseenUtil.uint2str(irs[i].CameraIp), irs[i].BasicInfo.CameraId);
                }
                for (i = 0; i < viss.Length; i++)
                {
                    s += string.Format("vis {0}\n", viss[i]);
                }
                return s;
            }).ContinueWith(x =>
            {
                txtEcho.Text = x.Result;
                btnDiscoverCameras.IsEnabled = true;
            }, TaskScheduler.FromCurrentSynchronizationContext());
        }

        public void ConfigPart(ConfigPartType type)
        {
            if (ConfigPartType.Head == type)
            {

            }
            else if (ConfigPartType.DeviceConfig == type)
            {
                deviceView.SetDeviceConfig(_clsDeviceConfig);
            }
            else if (ConfigPartType.ImageConfig == type)
            {
                deviceView.IRSetImageConfig(_clsImageConfig);
            }
        }
        #endregion

    }

    
}
