using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;

using MVVM;

using YoseenPTZ.ConfigDef;
using YoseenPTZ.CoreDef;

namespace YoseenPTZ.ViewDef
{
    public partial class ConfigSystemView : Window
    {
        #region Single
        static ConfigSystemView __instance;
        public static ConfigSystemView Instance
        {
            get
            {
                if (__instance == null)
                {
                    __instance = new ConfigSystemView();
                    __instance.Owner = App.Instance.ShellView;
                }
                return ConfigSystemView.__instance;
            }
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            //
            if (!_forceClose)
            {
                SaveConfig();
                e.Cancel = true;
                this.Hide();
            }
            base.OnClosing(e);
        }

        bool _forceClose;
        public static void ForceClose()
        {
            if (__instance == null) return;
            __instance._forceClose = true;
            __instance.Close();
            __instance = null;
        }
        #endregion

        readonly ConfigService _configService;
        readonly ClsHead _clsHead;
        readonly ClsDeviceConfig _clsDeviceConfig;
        readonly ClsImageConfig _clsImageConfig;
        ConfigSystemView()
        {
            MaterialDesignWindow.RegisterCommands(this);
            InitializeComponent();

            _configService = App.Instance.ConfigService;
            _clsHead = _configService._clsHead;
            _clsDeviceConfig = _configService._clsDeviceConfig;
            _clsImageConfig = _configService._clsImageConfig;

            //
            pgHead.SelectedObject = _clsHead;
            pgDeviceConfig.SelectedObject = _clsDeviceConfig;
            pgImageConfig.SelectedObject = _clsImageConfig;

            //
            _clsHead.PropertyChanged += head_PropertyChanged;
            _clsDeviceConfig.PropertyChanged += deviceConfig_PropertyChanged;
            _clsImageConfig.PropertyChanged += imageConfig_PropertyChanged;
        }

        bool _head_isChanged;
        private void head_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            _head_isChanged = true;
        }

        bool _deviceConfig_isChanged;
        private void deviceConfig_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            _deviceConfig_isChanged = true;
        }

        bool _imageConfig_isChanged;
        private void imageConfig_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            _imageConfig_isChanged = true;
            _afterChange?.Invoke();
        }

        void SaveConfig()
        {
            //
            if (_head_isChanged)
            {
                App.Instance.ConfigPart(ConfigPartType.Head);
                _head_isChanged = false;
            }
            
            //
            if (_deviceConfig_isChanged)
            {
                App.Instance.ConfigPart(ConfigPartType.DeviceConfig);
                _deviceConfig_isChanged = false;
            }

            //
            if (_imageConfig_isChanged)
            {
                App.Instance.ConfigPart(ConfigPartType.ImageConfig);
                _imageConfig_isChanged = false;
            }
        }

        Action _afterChange;
        public void ShowConfig(Action afterChange)
        {
            _afterChange = afterChange;
            this.Show();
        }
    }

}
