using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Controls;
using System.ComponentModel;
using System.Text.RegularExpressions;
using System.IO;

using MVVM;

using sdkdef = YoseenPTZ.SDKDef;

using YoseenPTZ.ConfigDef;
using YoseenPTZ.CoreDef;
using YoseenPTZ.ResourceDef;
using System.Threading;

namespace YoseenPTZ.ViewDef
{
    public partial class PresetView : Window
    {
        #region single
        static PresetView __instance;
        public static void ShowView(DeviceView deviceView)
        {
            if (__instance == null)
            {
                __instance = new PresetView(deviceView);
                __instance.Owner = App.Instance.ShellView;
                __instance.Show();
            }
            else
            {
                __instance.Show();
            }
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            if (!_forceClose)
            {
                e.Cancel = true;
                this.Hide();
            }
            base.OnClosing(e);
        }

        bool _forceClose;
        public static void ForceClose()
        {
            if (__instance == null) return;
            __instance._forceClose = true;
            __instance.Close();
            __instance = null;
        }
        #endregion

        readonly DeviceView _deviceView;

        readonly ClsTestInfo _clsTestInfo;

        PresetView(DeviceView deviceView)
        {
            MaterialDesignWindow.RegisterCommands(this);
            InitializeComponent();

            //
            _deviceView = deviceView;
            dgPreset.ItemsSource = deviceView.PresetArray;

            _clsTestInfo = new ClsTestInfo();
            pgTest.SelectedObject = _clsTestInfo;
        }

        private void btnPresetGoto_Click(object sender, RoutedEventArgs e)
        {
            ClsPreset preset = dgPreset.SelectedItem as ClsPreset;
            if (preset == null) return;
            int presetId = preset.ext_index;
            int ret;
            ret = _deviceView.PresetGoto(presetId);
        }

        private void btnPresetSave_Click(object sender, RoutedEventArgs e)
        {
            ClsPreset preset = dgPreset.SelectedItem as ClsPreset;
            if (preset == null) return;
            int presetId = preset.ext_index;
            int ret;
            ret = _deviceView.PresetSave(preset, presetId);
        }


        #region test
        Thread _test_thread;
        bool _test_working = false;
        void TestLoop()
        {
            ClsTestInfo info = _clsTestInfo;
            int presetStart = info.PresetStart;
            int presetEnd = info.PresetEnd;
            int interval = info.Interval * 1000;

            int sleepStep = 200;
            int sleepCount = interval / sleepStep;
            int preset = presetStart;
            int ret;

            if (presetEnd <= presetStart) return;

            //
            Action<int> act = new Action<int>((x) =>
            {
                dgPreset.SelectedIndex = x;
            });


            bool dir = true;
            while (_test_working)
            {
                //!!!ret=p|t|z;
                ret = _deviceView.PresetGoto(preset);
                LogUtil.Info($"Goto Preset {preset}, ret {ret}");
                if (0 < ret)
                {
                    Dispatcher.BeginInvoke(act, (int)preset);
                }

                int i;
                for (i = 0; i < sleepCount && _test_working; i++)
                {
                    Thread.Sleep(sleepStep);
                }

                //
                if (dir)
                {
                    if (preset < presetEnd)
                    {
                        preset++;
                    }
                    else
                    {
                        preset = presetEnd - 1;
                        dir = false;
                    }
                }
                else
                {
                    if (preset > presetStart)
                    {
                        preset--;
                    }
                    else
                    {
                        preset = presetStart + 1;
                        dir = true;
                    }
                }

            }
        }

        private void btnTest_Click(object sender, RoutedEventArgs e)
        {
            if (_test_working)
            {
                _test_working = false;
                _test_thread.Join();
            }
            else
            {
                _test_working = true;
                _test_thread = new Thread(new ThreadStart(TestLoop));
                _test_thread.Start();
            }

            //
            if (_test_working)
            {
                //dgPreset.IsEnabled = false;
                btnTest.Content = "测试-停止";
            }
            else
            {
                //dgPreset.IsEnabled = true;
                btnTest.Content = "测试-开始";
            }
        }
        #endregion

    }




}
