/*******************************************************************************************************
* Busi.h
*
*
*
********************************************************************************************************/
#ifndef XXX_BUSI_H_
#define XXX_BUSI_H_

#include <yc_type.h>

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//

//BusiType
#define MAP_BusiType(XX)   \
XX(0, None, None)\
XX(1, TLZW, TLZW)
enum BusiDataType {
#define XX(num, name, string)   BusiType_##name = num,
    MAP_BusiType(XX)
#undef XX
};

//
#define BusiData_HeadSize			512
#define BusiData_SizeMin			BusiData_HeadSize
#define BusiData_SizeMax			(1024*1024*1024*4LL)
struct BusiDataHead {
    s64 size;//head+data
    s32 type;
    s32 pad;
    char sender_name[64];
    s64 sender_timestamp;
    s64 recver_timestamp;
    u8 reserved[BusiData_HeadSize - 96];
};

extern "C" {
    SDK_API const char* BusiType_num2str(s32 num);
    SDK_API s32 BusiData_Save(BusiDataHead* data, const char* dir);
    SDK_API BusiDataHead* BusiData_Create(s32 dataType, s64 dataSize);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//BusiServer
typedef struct _BusiServerConfig {
    char serverName[64];
    char serverIp[16];
    u16 serverPort;
    u16 timeout;

    //
    char dataDir[128];
    u8 saveDataAfterRecv;
    u8	pad[19];
}BusiServerConfig;
typedef void(__stdcall* BusiServerCallback)(s32 errorCode, BusiDataHead* busiData, void* customData);

//
struct _BusiServer;
typedef struct _BusiServer BusiServer;
extern "C" {
    SDK_API BusiServer* BusiServer_Create();
    SDK_API void BusiServer_Free(BusiServer** pp);
    SDK_API s32 BusiServer_Start(BusiServer* context, BusiServerConfig* config, BusiServerCallback cbFunc, void* cbData);
    SDK_API void BusiServer_Stop(BusiServer* context);
    SDK_API s32 BusiServer_FreeData(BusiServer* context, BusiDataHead* data);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//BusiClient
typedef struct _BusiClientConfig {
    char clientName[64];
    char serverIp[16];
    u16 serverPort;
    u16 timeout;
    u16 cacheSize;
    u16 deleteFileAfterSend;
    u8	pad[16];
}BusiClientConfig;
typedef void(__stdcall* BusiClientCallback)(s32 errorCode, BusiDataHead* busiData, void* customData);

//
struct _BusiClient;
typedef struct _BusiClient BusiClient;
extern "C" {
    SDK_API BusiClient* BusiClient_Create();
    SDK_API void BusiClient_Free(BusiClient** pp);
    SDK_API s32 BusiClient_Start(BusiClient* context, BusiClientConfig* config, BusiClientCallback cbFunc, void* cbData);
    SDK_API void BusiClient_Stop(BusiClient* context);
    SDK_API s32 BusiClient_PostData(BusiClient* context, BusiDataHead* data);
    SDK_API s32 BusiClient_PostFile(BusiClient* context, const char* fn);
}



#endif