/*******************************************************************************************************
*
*
*
*
********************************************************************************************************/
#ifndef YOSEENDEVICETYPES_H_
#define YOSEENDEVICETYPES_H_

#include "../yc_type.h"

//20230706
#define VOL_RANGE			32768

/*
数据类型
*/
enum xxxdatatype {
    xxxdatatype_vol = 0,		///< 
    xxxdatatype_voldelta = 1,		///< 
    xxxdatatype_temp = 2,		///< 温度流
    xxxdatatype_video = 3,		///< 视频流
    xxxdatatype_rtsp = 4,		///< 视频流rtsp
    xxxdatatype_mix = 5,		///< 混合流
};

/*
数据文件类型
*/
enum xxxmediafile {
    xxxmediafile_bmpx = 0,			///< 单帧温度文件, bmp扩展
    xxxmediafile_pngx,				///< 单帧温度文件, png扩展
    xxxmediafile_stream,			///< 多帧温度文件
    xxxmediafile_mp4,				///< mp4文件
    xxxmediafile_jpgx,				///< 单帧温度文件, jpg扩展
};

/**
设备文件类型
*/
enum xxxcamerafile {
    xxxcamerafile_bin = 0,			///< 设备程序包
    xxxcamerafile_cali,				///< 校准表
    xxxcamerafile_xcali,            ///< xcali[0-9].cali
    xxxcamerafile_log,				///< 日志

    xxxcamerafile_cali2,			///< 校准表2
    xxxcamerafile_cali3,			///< 校准表3

    xxxcamerafile_bad,				///< 坏点表

    xxxcamerafile_c2m,				///< 二次多段校准
    xxxcamerafile_c2m2,				///< 二次多段校准2

    xxxcamerafile_cust,				///< 用户校准
    xxxcamerafile_cust2,			///< 用户校准2

    xxxcamerafile_gaowen,			///< 高温校准
    //add20250408
    xxxcamerafile_occ
};

enum xxxcameramem {
    xxxcameramem_measure = 0,
    xxxcameramem_daba,					//202103
    xxxcameramem_gb28181,				//202105
    xxxcameramem_cust,                  //202406
    xxxcameramem_cust2,
    xxxcameramem_weiju,                 //202409
    xxxcameramem_hwconfig,				//202506
    xxxcameramem_fixdist,				//202506
    xxxcameramem_xcali,					//202511, readonly
    xxxcameramem_xcalipart,				//202511, rw
    //Busi, 202511
    xxxcameramem_BusiBegin = 100,
    xxxcameramem_BusiTLZW,
    xxxcameramem_BusiEnd = 999,
};

/**
调色板类型
*/
enum xxxpalette {
    xxxpalette_Autumn = 0,
    xxxpalette_BlackHot,
    xxxpalette_GlowBow,
    xxxpalette_HighContrast,
    xxxpalette_HotMetal,
    xxxpalette_IronBow,
    xxxpalette_Jet,
    xxxpalette_RainBow,
    xxxpalette_RedSaturation,
    xxxpalette_WhiteHot,
    xxxpalette_Winter,
    xxxpalette_IronBow2,
};

/**
红外调色板
*/
typedef struct _xxxpalettedata {
    char name[32];				///< 名称
    bgra data[256];				///< 数据
}xxxpalettedata;

/**
发现热像仪方式
*/
enum xxxdiscoverflags {
    xxxdiscoverflags_broadcast = 0x0001,	///< 广播
    xxxdiscoverflags_multicast = 0x0002,	///< 组播
    xxxdiscoverflags_broadcast2 = 0x0004,	///< 广播2
};

/**
*/
typedef struct _xxxfpavol4 {
    u16 gsk;
    u16 gfid;
    u16 vsk;
    u16 vbus;
}xxxfpavol4;

typedef struct _xxxfpavol4f {
    float gsk;
    float gfid;
    float vsk;
    float vbus;
}xxxfpavol4f;

enum xxxfpacint {
    xxxfpacint_0 = 0,
    xxxfpacint_1,
    xxxfpacint_2,
    xxxfpacint_3,
    xxxfpacint_4,
    xxxfpacint_5,
    xxxfpacint_6,
    xxxfpacint_7,
};

/**
点
*/
typedef struct _xxxpoint {
    u16 x;			///< 坐标x
    u16 y;			///< 坐标y
    u16 radius;		///< 半径, 以中心(x,y), 边长(radius*2+1)的方块代表点
}xxxpoint;

/**
线
*/
typedef struct _xxxline {
    u16 x0;			///< 起点x
    u16 y0;			///< 起点y
    u16 x1;			///< 终点x
    u16 y1;			///< 终点y
    u16 radius;		///< 
}xxxline;

/**
矩形
*/
typedef struct _xxxrectangle {
    u16 xmin;			///< x最小
    u16 ymin;			///< y最小
    u16 xmax;			///< x最大
    u16 ymax;			///< y最大
}xxxrectangle;

/**
测温对象类型
*/
enum xxxmeasuretype {
    xxxmeasuretype_point = 0,
    xxxmeasuretype_line,
    xxxmeasuretype_rectangle,
    xxxmeasuretype_ellipse,
    xxxmeasuretype_polyline,
    xxxmeasuretype_polygon,
};

/**
测温标志
*/
enum xxxmeasureflags {
    xxxmeasureflags_track_max = 0x01,	///< 高温追踪
    xxxmeasureflags_track_min = 0x02,	///< 低温追踪

    xxxmeasureflags_plot_max = 0x08,	///< 高温曲线
    xxxmeasureflags_plot_min = 0x10,	///< 低温曲线
    xxxmeasureflags_plot_avg = 0x20		///< 平均温曲线
};

/**
报警类型
*/
enum xxxalarmtype {
    xxxalarmtype_none = 0,
    xxxalarmtype_max,
    xxxalarmtype_min,
    xxxalarmtype_mid,
    xxxalarmtype_exmid,

    xxxalarmtype_maxmid,
};

/**
测温对象
*/
typedef struct _xxxmeasure {
    u8	id;						///< 序号
    u8	measuretype;			///< 类型
    u8	points;					///< 点数
    u8	emmi;					///< 发射率, 单位0.01
    u16 xydata[64];				///< 点数据, x0,y0,x1,y1,...

    u8	alarmtype;				///< 报警类型
    u8	measureflags;			///< 测量标志
    u8	pad[2];
    float alarmdata[4];			///< 报警温度值t0,t1,t2

}xxxmeasure;

/**
测温结果
*/
typedef struct _xxxresult {
    s32 alarmLevel;				///< 报警等级
    u16 maxX;					///< 最高温X
    u16 maxY;					///< 最高温Y

    u16 minX;					///< 最低温X
    u16 minY;					///< 最低温Y

    float max;					///< 最高温
    float min;					///< 最低温
    float avg;					///< 平均温
}xxxresult;

/**
测温对象-鼠标
*/
typedef struct _xxxmousemea {
    float x;
    float y;
}xxxmousemea;

/**
测温结果-鼠标
*/
typedef struct _xxxmouseresult {
    u16 x;
    u16 y;
    float temp;
}xxxmouseresult;

/**
屏蔽区
*/
typedef struct _xxxshield {
    u8		id;					///< 序号			
    u8		pad[3];				///< 预留
    u16		xydata[8];			///< 点数据p0,p1,p2,p3
}xxxshield;

/**
串口数据位
*/
enum xxxspdatabits {
    xxxspdatabits_5 = 5,
    xxxspdatabits_6,
    xxxspdatabits_7,
    xxxspdatabits_8,
};

/**
串口校验位
*/
enum xxxspparity {
    xxxspparity_none = 0,
    xxxspparity_odd,
    xxxspparity_even,
};

/**
串口停止位
*/
enum xxxspstopbits {
    xxxspstopbits_1 = 0,
    xxxspstopbits_2,
};

/**
串口波特率
*/
enum xxxspbaudrate {
    xxxspbaudrate_2400 = 0,
    xxxspbaudrate_4800,
    xxxspbaudrate_9600,

    xxxspbaudrate_19200,
    xxxspbaudrate_38400,
    xxxspbaudrate_57600,
    xxxspbaudrate_115200,
};

/**
串口用法
*/
enum xxxspusage {
    xxxspusage_custom = 0,
    xxxspusage_pelcod,
    xxxspusage_pelcop,
    xxxspusage_diaocang,
};

/**
GPIO输入类型
*/
enum xxxgpioinputtype {
    xxxgpioinputtype_none = 0,			///< 关闭
    xxxgpioinputtype_check,				///< 检查
    xxxgpioinputtype_capture,			///< 截图
};

/**
GPIO输出类型
*/
enum xxxgpiooutputtype {
    xxxgpiooutputtype_close = 0,		///< 关闭
    xxxgpiooutputtype_open,				///< 打开
};

/**
对焦区域
*/
typedef struct _xxxfocusrect {
    u16 xmin;		///< x最小
    u16 ymin;		///< y最小
    u16 xmax;		///< x最大
    u16 ymax;		///< y最大
}xxxfocusrect;

enum xxxfocustype {
    xxxfocustype_stop = 0,
    xxxfocustype_far,
    xxxfocustype_near,
};

/**
GPIO报警类型
*/
enum xxxgpioalarmtype {
    xxxgpioalarmtype_manual = 0,		///< 手动
    xxxgpioalarmtype_auto				///< 自动
};

/**
GPIO报警值
*/
enum xxxgpioalarmvalue {
    xxxgpioalarmvalue_low = 0,			///< 低
    xxxgpioalarmvalue_high,				///< 高
    xxxgpioalarmvalue_ignore,			///< 无
};

/**
GPIO报警
*/
typedef struct _xxxgpioalarm {
    u8 value0;			///< 报警值0
    u8 type0;			///< 报警类型0
    u8 time0;			///< 报警时间0

    u8 value1;			///< 报警值1
    u8 type1;			///< 报警类型1
    u8 time1;			///< 报警时间1
}xxxgpioalarm;

/**
串口数据
*/
typedef struct _xxxserialportdata {
    u8 size;				///< 数据大小
    u8 data[31];			///< 数据区
}xxxserialportdata;

/**
时间
*/
typedef struct _xxxdatetime {
    s32 year;			///< 年
    s32 mon;			///< 月
    s32 day;			///< 日

    s32 hour;			///< 时
    s32 min;			///< 分
    s32 sec;			///< 秒
}xxxdatetime;


typedef struct _xf_config {
    short ms_full;//ms
    short fc_full;//fc
    short fc1;//fc, cc0
    short fc2;//fc, cc1000

    short fc_delta;//fc
    short fc_small;//fc, 300
    u8	pad[4];
}xf_config;


enum PtzAction {
    //
    PtzAction_Stop,

    PtzAction_MoveUp,
    PtzAction_MoveDown,
    PtzAction_MoveLeft,
    PtzAction_MoveRight,

    PtzAction_MoveLeftUp,
    PtzAction_MoveRightUp,
    PtzAction_MoveLeftDown,
    PtzAction_MoveRightDown,

    //hk
    PtzAction_ZoomIn,
    PtzAction_ZoomOut,

    PtzAction_FocusFar,
    PtzAction_FocusNear,

    PtzAction_IrisOpen,
    PtzAction_IrisClose,

    //
    PtzAction_PresetSet,
    PtzAction_PresetClear,
    PtzAction_PresetGoto,

    //getpan+gettilt+getzoom
    PtzAction_GetPTZ,

    //setpan+settilt+setzoom
    PtzAction_SetPTZ,

    //hk
    PtzAction_SwitchLightPowerOn,
    PtzAction_SwitchLightPowerOff,

    PtzAction_SwitchWiperPowerOn,
    PtzAction_SwitchWiperPowerOff,

    //add20230209
    PtzAction_GetPan,
    PtzAction_SetPan,

    PtzAction_GetTilt,
    PtzAction_SetTilt,

    PtzAction_GetZoom,
    PtzAction_SetZoom,

    PtzAction_B160_Backlight,
    PtzAction_B160_GetVersion,

    /*
    * pelcod custom req+resp
    *
    * cmd0+cmd1+data0+data1
    *
    * req-pan, resp-tilt
    *
    * */
    PtzAction_B160_W4R4,

    /*
    * DiaoCang
    *
    */
    PtzAction_DiaoCang_SuiDong,
};

typedef struct _xxxptzcmd {
    u8 act;
    u8 arg;

    u8 pad[2];
    s32 pan;
    s32 tilt;
    s32 zoom;
}xxxptzcmd;

/*
0,		wh (x, y)
-90,	hw (h-1-y, x)
-180,	wh (w-1-x, h-1-y)
-270,	hw (y, w-1-x)
*/
enum xxxTransformType {
    xxxTransformType_None = 0,
    xxxTransformType_Rotate90,
    xxxTransformType_Rotate180,
    xxxTransformType_Rotate270,

    //
    xxxTransformType_MirrorX,
    xxxTransformType_MirrorY,
};

/*
设备基本信息
*/
#define Filter_Desmear_Min			0
#define Filter_Desmear_Max			4
typedef struct _CameraBasicInfo {
    char CameraId[32];				///< 序列号
    char CameraName[32];			///< 名称
    char CameraType[16];			///< 类型

    char FPAId[32];					///< 探测器序列号

    char HardwareId[32];			///< 硬件版本
    char SoftwareId[32];			///< 软件版本

    u16 DataWidth;			///< 数据宽度
    u16 DataHeight;			///< 数据高度

    /**数据帧率
    网络温度数据帧率=DataFps/(DataRatio*SendRatio)
    网络视频数据帧率=DataFps/DataRatio
    模拟视频帧率=DataFps/DataRatio
    */
    u16 DataFps;

    u16 DataRatio;			///< 发送率, 设备每隔多少帧取一帧数据
    u16 SendRatio;			///< 数据率, 设备每隔多少帧发一帧数据

    u8 DataTransform;		///< 数据变换类型
    u8	pad_filter[3];
    u8 Filter_Desmear;//0: close; 1: 1/2; 2: 1/4; 3: 1/8; 4: 1/16
    u8	Filter_Median;
    u8	pad[19];
    u8 SoftwareInternal;

    /*
    为保证视频上绘制的文字、测温对象、调色板清晰,
    温度数据分辨率低于640x480的图像放大到640x480, 再在此基础上绘制, H264编码, JPEG编码.
    */
    u16 VideoWidth;			///< 视频输出宽度
    u16 VideoHeight;		///< 视频输出高度
}CameraBasicInfo;

/**
设备网络信息
*/
typedef struct _CameraNetworkInfo {
    bool UseStaticIp;				///< 是否使用静态IP
    u8 pad;
    u16 MulticastPort;				///< 组播端口, 未使用

    u32 StaticIp;					///< 静态IP
    u32 SubnetMask;					///< 子网掩码
    u32 Gateway;					///< 网关

    u32 MulticastIp;				///< 组播IP, 未使用

    u8 MacAddr[6];					///< MAC地址

    u16 Mtu;
    u32 Dns;						///< 主DNS
    u32 Dns2;						///< 次DNS
    u8 reserved[16];
}CameraNetworkInfo;

/**
探测器信息
*/
typedef struct _FPAInfo {
    xxxfpavol4 vol4;
    u16 tint;
    u8  cint;
    u8 pad;
}FPAInfo;

typedef struct _FPAInfoHK160 {
    u8		data[80];	//40used

    u8		res64;	//res64
    u8		cint;
    u16		tint;
    u16		vtemp;	//140
    u8		bias;	//0-7v, 1-5v
    u8		pad[41];
}FPAInfoHK160;

typedef struct _AKItem {
    s16 fpa;
    u8 fos;
    u8 tint;
    u8 cap;
    u8 pad[3];
}AKItem;
typedef struct _FPAInfoAK {
    u8 tint;
    u8 dll_trim;
    u8 int_cap;
    u8 ibias;
    u8 ad_gain;
    u8 fos;
    u8 svrd;
    u8 nucr;
    u8 spwr;
    u8 agc_lg_l;
    u8 srd;

    //R384F, M384F
    u8 x1_trim_v2;
    u8 x1_xrdm;
    u8 x1_c3;

    //R384H, R640H
    u8 x2_srg;//0x07
    u8 x2_lg_en;//0x01
    u8 x2_adg;//0x3f
    u8 x2_svrs;//0x0f
    u8 x2_srsm0;//R640F,M640F,71-72bits
    u8 x2_srsm1;
    u8 x2_srsm2;

    //R1280F
    u8 x3_tos;
    u8 x3_srdm;
    u8 x3_sagcr;//1
    u8 x3_poc;//
    u8 pad[6];

    //
    u8 item_count;
    AKItem item_array[7];
}FPAInfoAK;
#define FPAInfoAK_AKItem_CountMax		7

typedef struct _FPAInfoGD {
    u8 reserved[88];
}FPAInfoGD;

typedef struct _FPAInfoCLW {
    //ad5625
    u16 ad_vdda;
    u16 ad_vddo;
    u16 ad_gpol;
    u16 ad_vr;
    u16 ad_subpv;
    u16 pad[3];

    //ad9269
    s8 ad_offset0;
    s8 ad_offset1;
    s8 ad_offset2;
    s8 ad_offset3;

    //det
    u32 tint;
    u8 origin;//0,1,2,3
    u8 gain;//0 high, 1 low
    u8 reserved[62];
}FPAInfoCLW;

/*
 * FPAInfoUL
 */
typedef struct _ULItem {
    s16 fpa;//0.01 C
    u16 gsk;//0.0012 V
    u16 tint;
    u16 gfid;//0.0012 V
    u8 pad[4];
}ULItem;
typedef struct _FPAInfoUL {
    //base, !!!FPAInfo!!!
    xxxfpavol4 vol4;
    u16 tint;
    u8  cint;
    u8 origin;

    //var
    u16 check_time_min;//second
    u16 check_vol_min;//1
    u16 check_tint_min;//1
    s16 vol_offset;
    u8 pad[27];
    u8 item_count;
    ULItem item_array[7];
}FPAInfoUL;
#define FPAInfoUL_ULItem_CountMax		7

/**
挡板校零信息
*/
typedef struct _FFCInfo {
    u8 frames_skipped_after_close;			///< 挡板关闭后忽略帧数
    u8 frames_accumlated_when_closed;		///< 挡板关闭后累积帧数
    u8 frames_skipped_after_open;			///< 挡板打开后忽略帧数
    u8 nst_enable;							///< 无挡片模式开关
    u16 time_interval;						///< 时间触发间隔, 单位帧数
    u16 temp_interval;						///< 温度触发间隔, 单位mK

    s8 af_rebound;							///< 自动对焦回弹, 单位帧数
    u8 fpa_shutter;							///< 有挡片1/(1C/60s), 内部参数
    s16 nst_delta;							///< 无挡片模式漂移

    u16 time_interval_sec;						///< 时间触发间隔, 单位秒
    u16 pad;
}FFCInfo;

/**
测温修正信息
*/
typedef struct _FixInfo {
    float AtmosphericTemperature;		///< 气温
    float RelativeHumidity;				///< 相对湿度
    float Visibility;					///< 能见度
    float RainfallIntensity;			///< 降雨强度
    float SnowfallIntensity;			///< 降雪强度
    float TargetDistance;				///< 目标距离

    float GlobalEmissivity;				///< 全局发射率
    float InfraredWindowTrans;			///< 红外窗口透过率
    float TempOffset;					///< 温度漂移

    u8 EnableAtmFix;					///< 是否开大气修正
    u8 pad[3];

    //20240621
    float InfraredWindowTempOffset;         ///< fixtrans, fpaTemp-InfraredWindowTempOffset
    u8 reserved[28];
}FixInfo;

/**
模拟视频信息
*/
typedef struct _TvoutInfo {
    u8				EnableTvout;		///< 是否开启模拟视频
    u8				PaletteType;		///< 调色板类型
    u16					pad;

    u8					SmallTarget_BG;
    u8					Zoom;				///< 数字变焦
    u16					XuiDisplayFlags;	///< 显示标志位, 参见XuiDisplayFlags

    float				Gain;				///< 增益
    u32					H264_Bitrate;		///< 流媒体比特率
    u16					H264_GopSize;		///< 流媒体图像组大小

    //add20180809
    u8					StrechType;			///< 算法类型
    u8					DDELevel;			///< DDE等级

    s16 man_temp0;							///< 手动温度0, 0.1C
    s16 man_temp1;							///< 手动温度1, 0.1C
    u8 man_enable;							///< 手动温度
    u8 Temp2Gray;
    u8					HDMIPreset;

    /*
    add20191204
    高温:	温度高于ct_temp0, 用ct_color0
    低温：	温度低于ct_temp0, 用ct_color0
    区间内： 温度介于[ct_temp0,ct_temp1], 用ct_color0
    区间外:	温度低于ct_temp0, 用ct_color0; 温度高于ct_temp1,用ct_color1
    */
    u8 CT_Type;								///< 温度标记类型
    s16 CT_Temp0;							///< 标记温度0, 单位0.1C
    s16 CT_Temp1;							///< 标记温度1, 单位0.1C
    s32 CT_Color0;							///< 标记颜色0
    s32 CT_Color1;							///< 标记颜色1
}TvoutInfo;

enum HDMIPreset {
    HDMIPreset_720x576 = 0,
    HDMIPreset_1280x720,
    HDMIPreset_1280x720_960x720,
};

/**
串口信息
*/
typedef struct _SerialPortInfo {
    u8 Usage;					///< 用法
    u8 PortAddr;				///< 串口地址
    u8 BaudRate;				///< 波特率
    u8 DataBits;				///< 数据位
    u8 StopBits;				///< 停止位
    u8 Parity;					///< 校验位
    u8 reserved[10];
}SerialPortInfo;

/**
GPIO信息
*/
typedef struct _GpioInfo {
    u8 Input0;		///< 输入0
    u8 Input1;		///< 输入1
    u8 Output0;		///< 输出0
    u8 Output1;		///< 输出0
    u8 reserved[12];
}GpioInfo;

/**
设备时间信息
*/
typedef struct _CameraTimeInfo {
    char	NtpServer[32];			///< 主NTP服务器
    char	NtpServer2[32];			///< 次NTP服务器
    char	TimeZone[32];			///< 时区
    u8		reserved[32];
}CameraTimeInfo;

/*
设备信息
*/
typedef struct _CameraPluginInfo {
    s32 version;

    //
    s32 onvif_version;
    s32 gb28181_version;
    s32 modbus_version;

    //
    char	username[16];
    char	password[16];

    //add20230215
    u8 onvif_enable;
    u8 gb28181_enable;
    u8 modbus_enable;//0 disable, 1 tcp, 3 tcp+rtu
    u8 ypdatavm_enable;//0 default ,1 2019
    u8 h5_enable;
    u8 reserved[11];
}CameraPluginInfo;


/*
设备OSD信息
*/
typedef struct _CameraOSDInfo {
    u16 loc_enable;
    u16 loc_x;
    u16 loc_y;

    u16 time_enable;
    u16 time_x;
    u16 time_y;

    char loc_name[128];//utf8

    s32 color;

    //272-x
    u8 pad[128];
}CameraOSDInfo;

/*
双光混合参数
*/
typedef struct _CameraOutputInfo {
    //mix
    u8 MixMode;					///< 混合模式
    u8 MixRatio;				///< 混合比例, 取值范围[1,8]
    u16 CropX;					///< 可见光裁剪X
    u16 CropY;					///< 可见光裁剪Y
    u16 CropWidth;				///< 可见光裁剪宽度
    u16 CropHeight;				///< 可见光裁剪高度

    //
    u8					StrechType;				///< 红外算法类型
    u8					DDELevel;				///< 红外DDE等级, 取值范围[0,8], 0代表关闭
    float				Gain;					///< 红外图像增益
    s16		MTTemp0;
    s16 	MTTemp1;
    u8		MTEnable;
    u8		pad;
    u8					PaletteType;			///< 红外调色板
    u8					Contrast;				///< 红外对比度, 默认50
    u8					Brightness;				///< 红外亮度, 默认50

    //
    u8					EnableHdmi;				///< 是否开启模拟视频
    u16					H264_GopSize;			///< 流媒体图像组大小
    u32					H264_Bitrate;			///< 流媒体码率, 单位: bps

    //
    u8					FlipIR;					///< 红外翻转
    u8					FlipVIS;				///< 可见光翻转
    u16					XStartVIS;				///< 可见光视场X, 内部参数
    u16					YStartVIS;				///< 可见光视场Y, 内部参数
    u8				Zoom;
    u8				pad2[4];
    u8              CTType;
    s16             CTTemp0;
    s16             CTTemp1;
}CameraOutputInfo;

/*
混合模式
*/
enum MixMode {
    MixMode_IR = 0,		///< 单红外
    MixMode_VIS,		///< 单可见
    MixMode_DSX,		///< 双波段
    MixMode_BLEND,		///< alpha混合
    MixMode_PIP,		///< 画中画
    MixMode_FUSION,		///< 

    //
    MixMode_MAX,
};

/*
翻转类型
*/
enum MixFlip {
    MixFlip_NN = 0,		///< 无翻转
    MixFlip_XN,			///< X翻转
    MixFlip_NY,			///< Y翻转
    MixFlip_XY,			///< XY翻转
};

/*
温度帧头
*/
typedef struct _DataFrameHeader {
    u16 Width;						///< 宽度
    u16 Height;						///< 高度
    u32 ComSize;					///< 压缩大小
    u8 DataType;					///< 数据类型
    u8 ComType;						///< 压缩类型
    u16 Index;						///< 帧索引

    /**
    全帧温度以16位有符号整数数组表示, 温度浮点值=温度整数值/Slope+Offset
    */
    u16 Slope;
    s16 Offset;

    s32 FPATemp;					///< 探测器温度, 内部使用
    s32 ShellTemp;					///< 等效机壳温度, 内部使用

    u8 Fixed;
    u8 GpioInput0;					///< GPIO输入0
    u8 GpioInput1;					///< GPIO输入1
    u8 pad;
    u32 UpdateCount;	//update div
    s64 Timestamp;					///< 时间戳, 单位100ns

    //20230612
    s32 ShellTempHW;
    u32 Index32;
    u8 reserved[80];
}DataFrameHeader;
#define DATA_FRAME_HEADER_SIZE					128
#define DataFrameHeader_Offset_Timestamp		32


/**
YP
*/
#define YPCMD_DiscPort					55501
#define YPCMD_Port						55502
#define YPDATA_Port						55503

#define YPCMD_DiscMulticastPort			55504
#define YPCMD_DiscMulticastAddr			"239.255.255.251"

#define YPDATATM_Port					55505
#define YPDATAVM_Port					55506
#define YPDATAXM_Port					55507

#define YPDATA_PortUdp					55508

#define YPCMD_DiscClientPort			55511

/**
控制类型
*/
enum CtlType {
    CtlType_Debug = 0,				///< 
    CtlType_ChangeDataType,			///< 
    CtlType_MoveShutter,			///< 
    CtlType_StoreFactory,			///< 
    CtlType_RestartCamera,			///< 重启设备
    CtlType_RestartCapture,
    CtlType_MakeFactory,

    CtlType_ManualFFC = 32,			///< 手动挡板校零
    CtlType_RestoreFactory,			///< 恢复出厂配置
    CtlType_FocusManual,			///< 手动对焦, 步进模式控制电动镜头电机
    CtlType_FocusAuto,				///< 自动对焦
    CtlType_SetAlarm,				///< 设置GPIO报警
    CtlType_DisableFFC,				///< 禁用挡板校零
    CtlType_FocusManual2,			///< 手动对焦, 启停模式控制电动镜头电机

    //add20210708
    CtlType_ZoomType,               ///< 0 stop, 1 in, 2 out
    CtlType_ZoomDelta				///< >0 in, <0 out; unit 5ms
};

/**
控制
*/
typedef struct _Ctl {
    u16 Type;					///< 类型
    union {
        u8 reserved[8];				///< 联合体大小
        u8 DataType;				///< 温度数据类型
        u8 ShutterState;			///< 0挡板开, 1挡板关
        s16 FocusDelta;				///< 步进模式, 电动镜头电机转动时间, 单位5ms, 正数-远焦, 负数-近焦
        xxxfocusrect FocusRect;		///< 自动对焦区域
        u8	FocusType;				///< 启停模式, 电动镜头电机转动方式, 0 停止, 1 远焦转动, 2 近焦转动
        xxxgpioalarm Alarm;			///< GPIO报警
        u8 DisableFFC;				///< 1禁用, 0启用

        s16 ZoomDelta;
        u8 ZoomType;
    }Data;
}Ctl;

/**
控制X类型
*/
enum CtlXType {
    CtlXType_GetTime = 0,	///< 获取设备时间, UTC
    CtlXType_SetTime,		///< 设置设备仪时间, UTC
    CtlXType_GetGear,		///< 获取测温档位
    CtlXType_SetGear,		///< 设置测温档位
    CtlXType_AutoFocus,		///< 自动对焦

    //add20180921
    CtlXType_XfGetConfig,	///< 
    CtlXType_XfSetConfig,	///< 
    CtlXType_XfGetCur,		///< 
    CtlXType_XfMove,		///< 
    CtlXType_XfReset,
    CtlXType_XfCheckDelta,

    CtlXType_GetExtBbConfig,		///< 获取外置黑体校正参数
    CtlXType_SetExtBbConfig,		///< 设置外置黑体校正参数

    //add20200619
    CtlXType_SyncNTP,
    //add20210607
    CtlXType_ExecutePtz,
    //add20220806
    CtlXType_SetMouseMea,
    //add20250916
    CtlXType_SetVdOffset,
    //add20250116
    CtlXType_Xf2AbsMove,
    CtlXType_Xf2RelMove,
    //add20250408
    CtlXType_ExecuteOCC,
    //add20250915
    CtlXType_SetResIndex,
    //add20251114
    CtlXType_FilterReset,
    CtlXType_FilterGoto,
    //
    CtlXType_SetGpioOutput = 128,

    //huix20210702
    CtlXType_Huix = 1024,
    CtlXType_GetVisCropData,
    CtlXType_SetVisCropData,
    CtlXType_GetVisCropIndex,
    CtlXType_SetVisCropIndex,

    //box20241111
    CtlXType_BoxSendAlarmTest = 2048,

    //
    CtlXType_Error = 4096,
};

/*
GPIO输出标志
*/
enum xxxgpiooutputflags {
    xxxgpiooutputflags_light = (1 << 0),
    xxxgpiooutputflags_ledy = (1 << 1),
    xxxgpiooutputflags_ledb = (1 << 2),
    xxxgpiooutputflags_alarm = (1 << 3),
    xxxgpiooutputflags_buzz = (1 << 4),
};

/*
GPIO输出
*/
typedef struct _xxxgpiooutput {
    s32 flags;
    s32 value;
}xxxgpiooutput;

/*
外置黑体校正参数
*/
typedef struct _ExtBbConfig {
    u16 enable;			///< 开启
    s16 temp;			///< 黑体温度, 单位: 0.1摄氏度
    u16 x;				///< 黑体中心X
    u16 y;				///< 黑体中心Y
    u16 radius;			///< 黑体中心半径, 1代表取3x3区域

    u8 pad[18];
}ExtBbConfig;

//
enum OCCCmdType {
    OCCCmdType_Auto = 0,
    OCCCmdType_Manual,
    OCCCmdType_Reload,
};
typedef struct _OCCCmd {
    s32 Type;
    s32 TestSaveAfterConfig;//frame
    s32 TestIndex;//0-15
}OCCCmd;
/**
控制操作
*/
typedef struct _CtlX {
    s32 Type;						///< 类型
    union {
        u8				Reserved[64];
        s32				Error;			///< 错误码
        xxxdatetime		Time;			///< 设备时间
        s32				GearLevel;		///< 测温档位
        xxxfocusrect	FocusRect;		///< 自动对焦区域
        xf_config	XfConfig;			///< 
        s32			XfMove;				///< 
        s32			XfCurType;			///< 
        xxxgpiooutput	GpioOutput;

        ExtBbConfig		BbConfig;		///< 外置黑体校正参数
        xxxptzcmd		PtzCmd;
        xxxmousemea		MouseMea;
        s32				VisCropIndex;
        s32             ResIndex;
        s32             VolOffset;
        s32				FilterTimeMax;	///< 10000ms
        s32				FilterPos;		///< 0-1-2-3
    }Data;
}CtlX;

/**
发现热像仪响应2
*/
typedef struct _DiscoverCameraResp2 {
    CameraBasicInfo BasicInfo;				///< 基本信息
    u32 CameraIp;							///< 设备IP
    struct _DiscoverCameraResp2* pNext;		///< 下一条响应
}DiscoverCameraResp2;

/*
配置热像仪IP, 广播方式
*/
typedef struct _ConfigIPReq {
    char CameraId[32];
    CameraNetworkInfo NetworkInfo;
}ConfigIPReq;

typedef struct _ConfigIPResp {
    char CameraId[32];
}ConfigIPResp;

/*
登入信息
*/
typedef struct _YoseenLoginInfo {
    char CameraAddr[128];			///< 设备地址
    char Username[32];				///< 用户名
    char Password[32];				///< 密码
}YoseenLoginInfo;

/*
登入信息V2
*/
typedef struct _YoseenLoginInfoV2 {
    char CameraAddr[128];			///< 设备地址
    char Username[32];				///< 用户名
    char Password[32];				///< 密码

    /*
    0: 表示使用默认端口
    */
    u16 PortConfig;					///< 配置端口, 默认55502
    u16 PortTemp;					///< 温度流端口, 默认55503
    u16 PortTempSingle;				///< 温度单帧端口, 默认55505
    u16 PortVideo;					///< 视频流端口, 默认55506, 非卡片机使用此端口传输视频数据
    u16 PortMix;					///< 混合流端口, 默认55507, 卡片机使用此端口传输视频数据

    u8 Reserved[22];
}YoseenLoginInfoV2;

/*
H264起始帧
*/
typedef struct _H264FrameStart {
    u32 EncDataSize;				///< 编码器数据大小
    u16 DataWidth;						///< 数据宽度
    u16 DataHeight;						///< 数据高度
    u8 EncData[120];				///< 编码器数据

    u16 FpsNum;						///< 帧率分子
    u16 FpsDen;						///< 帧率分母
    u16 VideoWidth;
    u16 VideoHeight;
    u8 Reserved[120];
}H264FrameStart;

#define H264FrameStart_Size				256
#define H264FrameStart_EncDataSize		120
#define H264FrameHeader_Size			1024

/*
H264帧测温结果
*/
typedef struct _H264_MeasureResult {
    s8	Index;
    s8	AlarmLevel;
    s8	Valid;
    s8	Pad;//

    float Max;				//最高温
    float Min;				//最低温
    float Avg;				//平均温

    u16 MaxX;				//最高温点坐标X
    u16 MaxY;				//最高温点坐标Y
    u16 MinX;				//最低温点坐标X
    u16 MinY;				//最低温点坐标Y
}H264_MeasureResult;

/*
H264帧头V1
*/
typedef struct _H264FrameHeader {
    //
    s32 Size;
    u16 Width;
    u16 Height;
    s32 ShellTemp;


    //
    H264_MeasureResult	GlobalResult;
    H264_MeasureResult	CenterResult;
    H264_MeasureResult LocalResults[8];
    u8 Pad[172];

    //add20220806
    xxxmouseresult MouseResult;
    u8 Reserved[592];
}H264FrameHeader;
#define H264FrameHeader_Size			1024

/*
H264帧头V2
*/
typedef struct _H264FrameHeaderV2 {
    //
    s32 Size;
    u16 Width;
    u16 Height;

    s32 ShellTemp;

    //
    s32 LocalResultFlags;
    xxxresult GlobalResult;
    xxxresult LocalResultArray[16];

    //add20220806
    xxxmouseresult MouseResult;
    u8 Reserved[592];
}H264FrameHeaderV2;

/*
vis, 1024+y
*/
#define H264RtspHead_Size				1024
typedef struct _H264RtspHead {
    s32 version;
    u16 width;
    u16 height;
}H264RtspHead;

/*
数据帧
*/
typedef struct _DataFrame {
    void* Head;					///< 温度数据帧头
    void* Temp;					///< 温度数据
    void* Com;					///< 温度数据压缩
    void* Bmp;					///< 位图数据
    void* H264;					///< H264帧头
    struct _DataFrame* Prev;	///< 前一帧
}DataFrame;

/*
预览回调
@param errorCode 错误码
@param dataFrame 数据帧
@param customData 用户数据
*/
typedef void(__stdcall* YoseenPreviewCallback)(s32 errorCode, DataFrame* dataFrame, void* customData);

/*
预览信息
*/
typedef struct _YoseenPreviewInfo {
    u8 DataType;											///< xxxdatatype_video 视频流, xxxdatatype_temp 温度流
    u8 TransType;                                           ///< 0 tcp, 1 udp
    u8 pad[2];
    void* Hwnd;												///< 显示窗口句柄, 可以为空
    YoseenPreviewCallback CustomCallback;					///< 预览回调, 可以为空
    void* CustomData;										///< 用户数据

    /*
    用户不用设置, 预览成功后, 用户据此调整显示窗口宽高比
    */
    u16 OutputWidth;							///< 显示画面宽度
    u16 OutputHeight;							///< 显示画面高度
}YoseenPreviewInfo;

/*
*/
typedef struct _YoseenRtspInfo {
    char Url[256];

    u8 TransMode;//0 tcp, 1 udp
    u8 CacheTime;//0 close, 1-10 cache seconds
    u8 CopyY;//0 16k, 1 16k+ydata
    u8 pad[5];

    //
    u16 DataWidth;
    u16 DataHeight;
}YoseenRtspInfo;

/*******************************************************************************************************
 *
 * XCali
 *
 *
 *******************************************************************************************************/
#define XCali_ResCountMax				10
#define XCali_CaliCountMax				10
//
typedef struct {
    u16 detType;
    u8 resCount;
    u8 caliCount;
    u8 reserved[60];
}XCaliHead;
//
typedef struct {
    u16 width;
    u16 height;
    u16 fpsNum;
    u16 fpsDen;
    u16 tag;
    u8 reserved[22];
} XCaliRes;
//
enum ShutterMode {
    ShutterMode_None = 0,
    ShutterMode_Nst,
    ShutterMode_NstP,
};
typedef struct {
    u8 enable;
    u8 filter;
    u16 lens;
    s16 envTempMin;
    s16 envTempMax;
    s16 bbTempMin;
    s16 bbTempMax;
    char name[32];
    u8 shutterMode;
    u8 pad[19];
    union {
        u8 fpa[256];
        FPAInfo ul;
        FPAInfoUL ulx;
        FPAInfoAK ak;
        FPAInfoCLW clw;
    };
} XCali1;
//
#define XCali2_EnvCountMax				4
#define XCali2_BbCountMax				24
typedef struct {
    float bb;
    float mea;
    float emmi;
} XCali2Point;
typedef struct {
    u8 enable;
    u8 envCount;
    u8 bbCount;
    u8 pad[53];
    float globalEnvTemp;						//20
    float globalEmissivity;						//0.97
    float shellArray[XCali2_EnvCountMax];
    XCali2Point pointArray[XCali2_EnvCountMax * XCali2_BbCountMax];
} XCali2;
//
typedef struct {
    u8 enable;
    u8 bbCount;
    u8 pad[62];
    XCali2Point pointArray[XCali2_BbCountMax];
} XCaliCust;
//
typedef struct {
    XCali1 cali1;
    XCali2 cali2;
    XCaliCust cust;
}XCali1Cali2Cust;
//
typedef struct {
    u32 work_time;//from XWork
    s32 fpa_temp;
    s32 shell_temp;
    s32 shell_tempHW;
    u8 res_cur;
    u8 cali_cur;
    u8 pad[46];
} XCaliState;
//
typedef struct {
    //xcali
    XCaliHead head;
    XCali1Cali2Cust caliArray[XCali_CaliCountMax];
    //
    XCaliRes resArray[XCali_ResCountMax];//HWSConfig
    XCaliState state;
} XCali;

//
enum XCaliPartType {
    XCaliPartType_Head = 0,
    XCaliPartType_Cali1,
    XCaliPartType_Cali2,
    XCaliPartType_Cust,
};
typedef struct {
    u8 partType;
    u8 partIndex;
    u8 pad[2];
    u8 data[2048];//>=sizeof(XCali2)
}XCaliPart;

//
typedef struct {
    u32 work_time;//sec
    u8 pad[60];
}XWork;

#endif
