package Test;

import Yoseen.YoseenData;
import Yoseen.YoseenSDK;
import Yoseen.YoseenUtil;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public class TestMeasure_Realtime {

    private static int _ret;
    private static YoseenSDK.YoseenDevice _device;
    private static YoseenData.CameraBasicInfo _cbi;
    private static YoseenData.DataFrame _frame;
    private static YoseenSDK.YoseenMeasure _meaContext;
    private static YoseenData.MeasureTemplate _mt;
    private static YoseenData.MeasureTemplateResult _mtr;

    private static int createMeaContext() {
        _meaContext = new YoseenSDK.YoseenMeasure();
        _mt = createMeasureTemplate();
//        _mt = downloadMeasureTemplate(); //从设备前端下载测温模板

        _mtr = new YoseenData.MeasureTemplateResult();

        _ret = _meaContext.init();
        if (0 != _ret) return _ret;
        _ret = _meaContext.setConfig(_mt);
        return _ret;
    }

    private static YoseenData.MeasureTemplate downloadMeasureTemplate() {
        YoseenData.MeasureTemplate mt = new YoseenData.MeasureTemplate();
        long mtp = Pointer.nativeValue(mt.getPointer());
        IntByReference size = new IntByReference(mt.size());
        _ret = _device.downloadMem(mtp, size);
        mt.autoRead();

        return mt;
    }

    private static YoseenData.MeasureTemplate createMeasureTemplate() {
        YoseenData.MeasureTemplate mt = new YoseenData.MeasureTemplate();
        YoseenData.MeasureTemplateHead mtHead = mt.Head;
        mtHead.width = _cbi.DataWidth;
        mtHead.height = _cbi.DataHeight;
        mtHead.shieldFlags = 0;
        mtHead.LMOFlags = 0x1;//0,1,2

        //lmo
        YoseenData.xxxmeasure mea = mt.LMOArray[0];
        mea.measuretype = YoseenUtil.xxxmeasuretype_polygon;
        mea.emmi = 97;
        mea.points = 4;
        mea.xydata[0] = 100;
        mea.xydata[1] = 100;
        mea.xydata[2] = 200;
        mea.xydata[3] = 100;
        mea.xydata[4] = 200;
        mea.xydata[5] = 200;
        mea.xydata[6] = 100;
        mea.xydata[7] = 200;
        mt.autoWrite();

        return mt;
    }

    private static void checkMT() {
        System.out.println("DataWidth = " + _cbi.DataWidth + "; DataHeight = " + _cbi.DataHeight);
        Pointer headPtr = new Pointer(_frame.Head);
        short slope = headPtr.getShort(12);
        short offset = headPtr.getShort(14);
        System.out.println("slope = " + slope + "; offset = " + offset);

        _meaContext.getResult(_frame.Head, _frame.Temp, _mtr);
        YoseenData.xxxresult result = _mtr.LMRArray[0];
        System.out.println(result.toString());
    }


    public static void main(String[] args) {
        String dddDebug = YoseenSDK.getDebugDir();


        //InitSDK
        _ret = YoseenSDK.YoseenDevice.initSDK();

        _device = new YoseenSDK.YoseenDevice();

        //Login
        _ret = _device.login("192.168.1.215");

        //Config
        _cbi = new YoseenData.CameraBasicInfo();
        _ret = _device.get_CameraBasicInfo(_cbi);


        //create meaContext
        _ret = createMeaContext();

        _frame = new YoseenData.DataFrame();

        //StartPreview, StopPreview
        YoseenData.YoseenPreviewCallback previewCallback = new YoseenData.YoseenPreviewCallback() {
            int _count = 0;

            public void callback(int errorCode, long dataFrame, long customData) {
                if (0 == errorCode) {
                    Pointer p = new Pointer(dataFrame);
                    _frame.Head = p.getLong(0);
                    _frame.Temp = p.getLong(8);
                    checkMT();
                }
                _count++;
                System.out.println(_count);

            }
        };
        _ret = _device.startPreview(YoseenUtil.xxxdatatype_temp, previewCallback);

        if (0 == _ret) {
            try {
                //wait
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        _device.stopPreview();

        //
        _meaContext.free();

        //Logout
        _device.logout();

        //FreeSDK
        YoseenSDK.YoseenDevice.freeSDK();
    }
}
