#ifndef HWCAMEARCONFIG_H_
#define HWCAMEARCONFIG_H_

#include "../yc_type.h"

/*******************************************************************************************************
 *
 *
 *
 *******************************************************************************************************/
 //HWStaticType
#define HWStaticType_MAP(XX)\
	XX(100, R1280A, R1280A)\
	XX(200, R384F, R384F)\
	XX(300, R640F, R640F)\
	XX(301, R640F_640x480, R640F)\
	XX(302, R640F_384x288, R384Z)\
	XX(303, R640F_384x288_fpga, R384G)\
	XX(304, R640F_30, R640F)\
	XX(400, R384H, R384H)\
	XX(401, R384H_256x192, R256H)\
	XX(402, R384H_U, R384H_U)\
	XX(500, R640H, R640H)\
	XX(501, R640H_640x480, R640H)\
	XX(502, R640H_U, R640H_U)\
    XX(503, R640H_150, R640H_150)\
	XX(600, R1280F, R1280F)\
	XX(601, R1280F_ALPHA, R1280F_ALPHA)\
	XX(700, R1280H, R1280H)\
	XX(701, R1280H_ALPHA, R1280H_ALPHA)\
	XX(800, CLW01, CLW01)\
	XX(801, CLW02, CLW02)\
	XX(802, CLW03, CLW03)\
	XX(803, CLW04, CLW04)\
	XX(804, CLW05, CLW05)\
	XX(1000, S384G, S384G)\
	XX(1100, S640F, S640F)\
	XX(1200, S384H, S384H)\
	XX(1201, S384H_U, S384H_U)\
	XX(1300, S640H, S640H)\
	XX(1301, S640H_U, S640H_U)

enum HWStaticType {
#define XX(num, name, string) HWStaticType_##name=num,
    HWStaticType_MAP(XX)
#undef XX
};

//
enum HWDetType {
    //
    HWDetType_NULL = 0,

    //x210
    HWDetType_U384A = 100,
    HWDetType_U384B,
    HWDetType_U640B,
    HWDetType_S384A,

    //x4418
    HWDetType_X384B = 200,
    HWDetType_X640A,
    HWDetType_X640B,
    HWDetType_X384D,
    HWDetType_X640D,
    HWDetType_X640E,

    HWDetType_X384C,
    HWDetType_X160A,
    HWDetType_X384A,
    HWDetType_X1024B,
    HWDetType_X1280B,
    HWDetType_X1024C,
    HWDetType_X640E_GDX,

    //m4418
    HWDetType_M384B = 300,
    HWDetType_M640A,
    HWDetType_M384D,
    HWDetType_M640D,
    HWDetType_M160A,
    HWDetType_M384F,
    HWDetType_M640F,
    HWDetType_M384G, //AK640->384

    //
    HWDetType_H160A = 400,
    HWDetType_H384D,
    HWDetType_H640D,
    HWDetType_H384F,
    HWDetType_H640F,

    //rk3568
    HWDetType_R1280A = 500,
    HWDetType_R384F,
    HWDetType_R640F,
    HWDetType_R384H,
    HWDetType_R640H,
    HWDetType_R1280F,
    HWDetType_R1280H,
    HWDetType_R384G,//R640F_384x288_fpga
    HWDetType_CLW01,
    HWDetType_CLW02,
    HWDetType_CLW03,
    HWDetType_CLW04,
    HWDetType_CLW05,

    //rk3566
};

enum HWShutterType {
    HWShutterType_A = 0,
    HWShutterType_B
};

enum HWFocusType {
    HWFocusType_Outside = 0,
    HWFocusType_Inside
};

//HWCaliType
#define HWCaliType_MAP(XX)\
	XX(0,	GD,	GD)\
	XX(1,	GS,	GS)\
	XX(100,	AK,	AK)\
	XX(101,	AKX,	AKX)\
	XX(102,	AKGS,	AKGS)\
	XX(103,	AKGW,	AKGW)\
	XX(104,	AKWJ,	AKWJ)\
	XX(105,	CLWWJ,	CLWWJ)\
	XX(106,	AKXWJ,	AKXWJ)\
    XX(107, CLWXCALI, CLWXCALI)\
    XX(108, AKXXCALI, AKXXCALI)
enum HWCaliType {
#define XX(num, name, string) HWCaliType_##name=num,
    HWCaliType_MAP(XX)
#undef XX
};

//HWVideoPreset
enum HWVideoPreset {
    HWVideoPreset_Auto = 0,
    HWVideoPreset_720x576,
};

//
#define HWSConfig_DataFormatMax			10
typedef struct _HWDataFormat {
    u16 Width;
    u16 Height;
    u16 FpsNum;
    u16 FpsDen;
} HWDataFormat;

typedef struct _HWSConfig {
    u16 StaticType;
    u16 DetType;
    s32 FpsNum;
    s32 FpsDen;
    u16 Width;
    u16 Height;
    u16 CropWidth;
    u16 CropHeight;
    u16 VideoWidth;
    u16 VideoHeight;
    s32 FpaTempSlope;
    s32 FpaTempIntercept;
    HWDataFormat FormatArray[HWSConfig_DataFormatMax];
    u8 pad[400];
}HWSConfig;

typedef struct _HWDConfig {
    u16 StaticType;
    u16 FrameCount;
    u16 VideoEnable;
    u16 ShutterType;
    u16 FocusType;
    u16 CaliType;
    u8 VideoPreset;//RK3566, hdmi=>tvout
    u8 FormatIndex;//CLW
    u8 FilterEnable;//CLW
    u8 pad;
    s32 EnableFPATemp;//CLW, mK
    u16 BusiType;
    u8 reserved[490];
} HWDConfig;

/*******************************************************************************************************
 *
 *
 *
 *******************************************************************************************************/
BEGIN_EXTERN_C

SDK_API HWSConfig* HW_GetStaticConfigArray(s32* count);
SDK_API void HW_Free(void** pp);

END_EXTERN_C

#endif//HWCAMEARCONFIG_H_
