/*********************************************************************************************************
* TempFile.h
* 2023-10-01: init
*
*********************************************************************************************************/
#ifndef XXX_TEMPFILE_H_
#define XXX_TEMPFILE_H_

#include "XMea.h"
#include <YoseenSDK/YoseenAlg_Strech.h>
#include <YoseenSDK/YoseenFileTypes.h>

enum TFFileType {
    TFFileType_None = 0,
    TFFileType_Jpg,
    TFFileType_Stream,
    TFFileType_Mp4,				   
};

struct TFTemp {
    union {
        frame_file_header   ffh;
        stream_file_header  sfh;
    };
    u8                  custom[16 * 1024];
    DataFrameHeader     dfh;
    //dfd
};

#define TFConf_Version             20251016
#define TFConf_MeaCountMax         32
struct TFConf {
    //readonly
    s32 version;
    s32 pad;
    s64 timestamp;
    char camera_id[32];
    u16 width;
    u16 height;
    u16 fps_num;
    u16 fps_den;
    u32 frame_count;
    FixInfo fix;
    char camera_type[16];
    u8 reserved[128];

    //image, eof readonly
    u32 palette_type;
    strech_control sc;

    //mea
    s32 mea_count;
    XMea mea_array[TFConf_MeaCountMax];
};

struct TFRaw {
    u8* jpg;
    TFTemp* temp;
    TFConf* conf;
    s32 jpgSize;
    s32 tempSize;
    s32 confSize;
};

struct TFFrame {
    DataFrameHeader* head;
    s16* temp;
    void* bmp;
};

struct TFMeaConfigData {
    s32 mea_count;
    XMea mea_array[0];//
};
struct TFMeaResultData {
    s32 frame_count;
    s32 mea_count;
    s64* time_array;//frame_count*8
    XResult* result_array;//frame_count*mea_count
};
typedef void(__stdcall* MeaResultDataCallback)(s32 errorCode, TFMeaResultData* data, void* customData);

//TFMapData
#define TFMapData_ItemArray_Size        256
#define TFMapData_ItemArray_Mid         85
struct TFMapItem {
    s16 temp;
    u16 pad;
    s32 color;
};
struct TFMapData {
    s16 temp_min;
    s16 temp_min01;
    s16 temp_max99;
    s16 temp_max;
    TFMapItem item_array[TFMapData_ItemArray_Size];
};

//
struct _TFContext;
typedef struct _TFContext TFContext;
extern "C" {
    //
    SDK_API TFContext* TF_Create();
    SDK_API void TF_Free(TFContext** pp);

    //
    SDK_API s32 TF_Open(TFContext* context, const char* fn, s32 ft);
    SDK_API void TF_Close(TFContext* context);

    //
    SDK_API s32 TF_SetImage(TFContext* context, s32 paletteType, strech_control* sc);

    //
    SDK_API s32 TF_ReadFrame(TFContext* context, s32 index, TFFrame* frame);
    SDK_API s32 TF_ReadFrameWithMap(TFContext* context, s32 index, TFFrame* frame, TFMapData* md);
    SDK_API s32 TF_ReadFrameHead(TFContext* context, s32 index, TFFrame* frame);

    //
    SDK_API s32 TF_ReadRaw(TFContext* context, TFRaw* raw);
    SDK_API s32 TF_WriteRawBegin(TFContext* context, TFRaw* rawTmp);
    SDK_API s32 TF_WriteRawCheckConf(TFContext* context, TFRaw* rawTmp);
    SDK_API s32 TF_WriteRawEnd(TFContext* context, TFRaw* rawTmp, const char* fn);

    //
    SDK_API s32 TF_CreateMeaResultData(TFContext* context, TFMeaConfigData* configData, TFMeaResultData** ppResultData);

    SDK_API s32 TF_SaveTemp(TFContext* context, const char* fn);
}

#endif
