/*********************************************************************************************************
* TempFilePrivate.h
* 2023-10-01: init
*
*********************************************************************************************************/
#ifndef XXX_TEMPFILEPRIVATE_H_
#define XXX_TEMPFILEPRIVATE_H_

#include "TempFile.h"
#include <YoseenSDK/YoseenSDK.h>
#include <yc_utf8.h>
#include <yc_file.h>

/*********************************************************************************************************
*
* jpg: jpg+conf+temp
*
* stream: bmp+...+conf
*
*********************************************************************************************************/
enum EChunkType {
    EChunkType_None = 0,
    EChunkType_Temp = 0x504d4554,//TEMP
    EChunkType_Conf = 0x464e4f43,//CONF
    EChunkType_Visi = 0x49534956,//VISI
};

/**
Chunk
===========================================
head        length+type, 8
data		x
tail        36
===========================================
*/
struct ChunkHead {
    s32                 length;//data
    s32                 type;
};
struct ChunkTail {
    u16 width;
    u16 height;
    s32 version;
    s32 length;//data
    s32 type;
    u8 reserved[20];
};
struct ChunkInfo {
    s32 type;
    s32 size;
    s64 offset;
};

#define TFContext_PixelsMin              (160*120) 
#define TFContext_PixelsMax              (1280*1024)

//
#define Jpg_Size_Max                 (1024*1024*2)

//
#define ChunkConf_DataSize_Max            (1024*1024*2)
#define ChunkConf_Size_Max                (8+ChunkConf_DataSize_Max+36)
#define ChunkTemp_DataSize(pixels)          (128+16*1024+128+pixels*2)
#define ChunkTemp_Size(pixels)              (8+ChunkTemp_DataSize(pixels)+36)
#define ChunkTemp_DataSize_Max            (ChunkTemp_DataSize(TFContext_PixelsMax))
#define ChunkTemp_Size_Max                (8+ChunkTemp_DataSize_Max+36)

#define Chunk_Data2Head(data)               (((u8*)(data))-8)

//
#define TFRaw_Size_Max                          (Jpg_Size_Max + ChunkConf_Size_Max+ChunkTemp_Size_Max)
#define TFContext_RawSizeAll                    (TFRaw_Size_Max*3)

//
#define TFContext_FrameCount                  4
#define TFContext_FrameCountM1                (TFContext_FrameCount-1)
#define TFContext_FrameSizeAll                (TFContext_FrameCount*(128+TFContext_PixelsMax*6))//head+temp+bmp

//
/*********************************************************************************************************
*
*
*********************************************************************************************************/
enum TFContextState {
    TFContextState_None = 0,
    TFContextState_Jpg,
    TFContextState_Stream,
};

typedef struct _TFContext {
    s32 state;

    //alg
    strech_context* alg;
    s32 alg_paletteDataCount;
    xxxpalettedata* alg_paletteDataAll;
    xxxpalettedata* alg_paletteDataCur;
    strech_control alg_strechControl;

    //
    TFRaw raw_read;
    TFRaw raw_write;
    u8* raw_writeCombine;//jpg+conf+temp

    //
    u32 frame_count;
    u32 frame_read;
    TFFrame frame_array[TFContext_FrameCount];

    //
    FILE* filePtr;

    //
    s32 dataWidth;
    s32 dataHeight;
    s32 dataPixels;
    s32 dataFrameSize;//head+temp
    s32 dataFrame0Offset;
    s64 dataFrameEnd;
}TFContext;

//
void sc_init(strech_control* sc);
void bmp_temp2conf(TFTemp* temp, TFConf* conf);
void jpg_temp2conf(TFTemp* temp, TFConf* conf);
void stream_sfh2conf(stream_file_header* sfh, TFConf* conf);

#endif