#ifndef XXX_DEVICE_H_
#define XXX_DEVICE_H_

//sdk
#include <YoseenSDK/YoseenSDK.h>
//
#include <QObject>

class Device : public QObject{
    Q_OBJECT

    /*********************************************************************
     *
     *
     * init, free sdk
     *
     * ******************************************************************/
public:
    static int initSDK();
    static void freeSDK();


public:
    explicit Device(QObject *parent = nullptr);
    ~Device() override;

    /*********************************************************************
     *
     * preview, callback
     *
     * ******************************************************************/
private:
    static void __stdcall onFrameRecvedStatic(s32 errorCode, DataFrame* dataFrame, void* customData);
    void onFrameRecved(s32 errorCode, DataFrame* dataFrame);
signals:
    void frameRecved(int errorCode, DataFrame* dataFrame);
    void gpioInputChanged(int oldValue, int newValue);

public:
    /*********************************************************************
     *
     * login
     *
     *
     * ******************************************************************/
    int login(char* ip);
    void logout();

    int saveJpg(char* fn);
    int sendControl(Ctl* ctl);
    int sendControlX(CtlX* ctlx);

    /*********************************************************************
     *
     * preview
     *
     *
     * ******************************************************************/
    int startPreivew(s32 dataType);
    void stopPreview();
    void pausePreview(s32 pause);
    int beginSave(char* fn, s32 ft);
    void endSave(s32 ft);

    //
    int getTempWidth(){return m_basicInfo.DataWidth;}
    int getTempHeight(){return m_basicInfo.DataHeight;}
    int getVideoWidth(){return m_basicInfo.VideoWidth;}
    int getVideoHeight(){return m_basicInfo.VideoHeight;}
    int getUserHandle(){return m_userHandle;}

private:
    int m_userHandle;
    int m_previewHandle;
    CameraBasicInfo     m_basicInfo;
    YoseenPreviewInfo   m_previewInfo;
    YoseenLoginInfo     m_loginInfo;
    int m_gpioInputLast;
};

#endif // XXX_DEVICE_H_
