/*
红外设备类封装
*/
#ifndef YOSEENCAMERA_H_
#define YOSEENCAMERA_H_

#include <YoseenSDK/YoseenSDK.h>

//前置类定义
class YoseenCamera;

//用户定义的数据接收回调
typedef void(__stdcall *Func_FrameRecved)(YoseenCamera* camera, DataFrame* dataFrame);

//用户定义的连接改变回调
typedef void(__stdcall *Func_ConnectChanged)(YoseenCamera* camera, s32 state);


//设备类
class YoseenCamera{

public:
	//初始化SDK
	static s32 InitSDK();

	//释放SDK
	static void FreeSDK();

public:
	YoseenCamera();
	~YoseenCamera();

	//登入, 退出
	s32 Login(const char* cameraIp);
	void Logout();

	//开始和停止温度流预览
	s32 StartPreview(Func_FrameRecved funcFrameRecved, Func_ConnectChanged funcConnectChanged);
	void StopPreview();

	//手动挡板校零
	s32 ManualFFC();

private:
	//SDK定义的数据接收回调
	static void __stdcall FrameRecvedStatic(s32 errorCode, DataFrame* dataFrame, void* customData);
	void FrameRecved(s32 errorCode, DataFrame* dataFrame);

private:
	s32 mUserHandle;					//用户句柄，登入和退出相关
	s32 mPreviewHandle;					//预览句柄，开始和停止预览相关
	CameraBasicInfo mBasicInfo;			//设备基本信息

	Func_FrameRecved mFuncFrameRecved;			//数据接收回调
	Func_ConnectChanged mFuncConnectChanged;	//连接改变回调
};



#endif