﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.ServiceModel.Discovery;
using System.Text;
using System.Threading;
using System.Xml;
using System.Xml.Serialization;

namespace YoseenSDKCS.HKDef
{
    public static class HKSDK
    {
        public static string[] DiscoverDevices()
        {
            FindCriteria findCriteria = new FindCriteria();
            string contractTypeName = "NetworkVideoTransmitter";
            string contractTypeNamespace = "http://www.onvif.org/ver10/network/wsdl";
            findCriteria.ContractTypeNames.Add(new XmlQualifiedName(contractTypeName, contractTypeNamespace));
            findCriteria.MaxResults = 16;
            findCriteria.Duration = TimeSpan.FromSeconds(2);
            UdpDiscoveryEndpoint endpoint = new UdpDiscoveryEndpoint(DiscoveryVersion.WSDiscoveryApril2005);
            DiscoveryClient discoveryClient = new DiscoveryClient(endpoint);
            FindResponse findResponse = discoveryClient.Find(findCriteria);

            HashSet<string> ipHashSet = new HashSet<string>();
            foreach (var a in findResponse.Endpoints)
            {
                foreach (var b in a.ListenUris)
                {
                    if (b.HostNameType == UriHostNameType.IPv4)
                    {
                        ipHashSet.Add(b.Host);
                    }
                }
            }
            return ipHashSet.ToArray();
        }

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_Init();

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_Cleanup();

        [DllImport(@"HCNetSDK.dll")]
        public static extern uint NET_DVR_GetLastError();

        [DllImport(@"HCNetSDK.dll")]
        public static extern Int32 NET_DVR_Login_V30(string sDVRIP, Int32 wDVRPort, string sUserName, string sPassword, ref NET_DVR_DEVICEINFO_V30 lpDeviceInfo);

        [DllImport(@"HCNetSDK.dll")]
        public static extern int NET_DVR_Login_V40(ref NET_DVR_USER_LOGIN_INFO pLoginInfo, ref NET_DVR_DEVICEINFO_V40 lpDeviceInfo);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_Logout(int iUserID);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_PTZControl_Other(Int32 lUserID, Int32 lChannel, uint dwPTZCommand, uint dwStop);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_PTZControlWithSpeed_Other(int lUserID, int lChannel, uint dwPTZCommand, uint dwStop, uint dwSpeed);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_PTZPreset_Other(int lUserID, int lChannel, uint dwPTZPresetCmd, uint dwPresetIndex);

        /*
         pelco, HK
         
         */
        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_GetDVRConfig(int lUserID, uint dwCommand, int lChannel, IntPtr lpOutBuffer, uint dwOutBufferSize, ref uint lpBytesReturned);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_SetDVRConfig(int lUserID, uint dwCommand, int lChannel, System.IntPtr lpInBuffer, uint dwInBufferSize);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_GetSTDConfig(int iUserID, uint dwCommand, ref NET_DVR_STD_CONFIG lpConfigParam);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_SetSTDConfig(int iUserID, uint dwCommand, ref NET_DVR_STD_CONFIG lpConfigParam);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_GetSTDAbility(int lUserID, uint dwAbilityType, ref NET_DVR_STD_ABILITY lp);

        /*
         pelco, d
         */
        [DllImport(@"HCNetSDK.dll")]
        public static extern int NET_DVR_SerialStart(int lUserID, int lSerialPort, SERIALDATACALLBACK fSerialDataCallBack, uint dwUser);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_SerialSend(int lSerialHandle, int lChannel, IntPtr pSendBuf, uint dwBufSize);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_SerialStop(int lSerialHandle);

        /*
         cap
         */
        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_CaptureJPEGPicture(int lUserID, int lChannel, ref NET_DVR_JPEGPARA lpJpegPara, string sPicFileName);

        [DllImport(@"HCNetSDK.dll")]
        public static extern bool NET_DVR_CaptureJPEGPicture_NEW(int lUserID, int lChannel, ref NET_DVR_JPEGPARA lpJpegPara, IntPtr ptr, int dwPicSize, ref int lpSizeReturned);
    }

    public static class HKConsts
    {
        public const int SERIALNO_LEN = 48;
        public const int InvalidChannel = -1;

        public const int Ptz_LightPowerOn = 2;
        public const int Ptz_WiperPowerOn = 3;
        public const int Ptz_FanPowerOn = 4;
        public const int Ptz_HeaterPowerOn = 5;

        public const int Ptz_AuxPowerOn1 = 6;
        public const int Ptz_AuxPowerOn2 = 7;

        public const int Ptz_SetPreset = 8;
        public const int Ptz_ClearPreset = 9;

        public const int Ptz_ZoomIn = 11;
        public const int Ptz_ZoomOut = 12;

        public const int Ptz_FocusNear = 13;
        public const int Ptz_FocusFar = 14;

        public const int Ptz_IrisOpen = 15;
        public const int Ptz_IrisClose = 16;

        public const int Ptz_Up = 21;
        public const int Ptz_Down = 22;
        public const int Ptz_Left = 23;
        public const int Ptz_Right = 24;

        public const int Ptz_LeftUp = 25;
        public const int Ptz_RightUp = 26;
        public const int Ptz_LeftDown = 27;
        public const int Ptz_RightDown = 28;

        public const int Ptz_Auto = 29;
        public const int Ptz_GotoPreset = 39;

        //
        public const int Port = 8000;
        public const int Size_SerialNumber = 48;

        //

        public const int NET_DVR_SET_PTZPOS = 292;
        public const int NET_DVR_GET_PTZPOS = 293;
        public const int NET_DVR_GET_PTZSCOPE = 294;

        public const int NET_DVR_GET_CCDPARAMCFG = 1067;
        public const int NET_DVR_SET_CCDPARAMCFG = 1068;

        public const int NET_DVR_GET_EXTERNALDEVICE = 3723;
        public const int NET_DVR_GET_SUPPLEMENTLIGHT = 3728;

        public const int NET_DVR_SET_EXTERNALDEVICE = 3724;
        public const int NET_DVR_SET_SUPPLEMENTLIGHT = 3729;

        public static NET_DVR_JPEGPARA jpgPara = new NET_DVR_JPEGPARA() { wPicSize = 0xff, wPicQuality = 1 };
    }

    public delegate void SERIALDATACALLBACK(int lSerialHandle, IntPtr pRecvDataBuffer, uint dwBufSize, uint dwUser);

    //NET_DVR_Login_V30()参数结构
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_DEVICEINFO_V30
    {
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = HKConsts.SERIALNO_LEN, ArraySubType = UnmanagedType.I1)]
        public byte[] sSerialNumber;  //序列号
        public byte byAlarmInPortNum;               //报警输入个数
        public byte byAlarmOutPortNum;              //报警输出个数
        public byte byDiskNum;                  //硬盘个数
        public byte byDVRType;                  //设备类型, 1:DVR 2:ATM DVR 3:DVS ......
        public byte byChanNum;                  //模拟通道个数
        public byte byStartChan;                    //起始通道号,例如DVS-1,DVR - 1
        public byte byAudioChanNum;                //语音通道数
        public byte byIPChanNum;                    //最大数字通道个数，低位  
        public byte byZeroChanNum;          //零通道编码个数 //2010-01-16
        public byte byMainProto;            //主码流传输协议类型 0-private, 1-rtsp,2-同时支持private和rtsp
        public byte bySubProto;             //子码流传输协议类型0-private, 1-rtsp,2-同时支持private和rtsp
        public byte bySupport;        //能力，位与结果为0表示不支持，1表示支持，
                                      //bySupport & 0x1, 表示是否支持智能搜索
                                      //bySupport & 0x2, 表示是否支持备份
                                      //bySupport & 0x4, 表示是否支持压缩参数能力获取
                                      //bySupport & 0x8, 表示是否支持多网卡
                                      //bySupport & 0x10, 表示支持远程SADP
                                      //bySupport & 0x20, 表示支持Raid卡功能
                                      //bySupport & 0x40, 表示支持IPSAN 目录查找
                                      //bySupport & 0x80, 表示支持rtp over rtsp
        public byte bySupport1;        // 能力集扩充，位与结果为0表示不支持，1表示支持
                                       //bySupport1 & 0x1, 表示是否支持snmp v30
                                       //bySupport1 & 0x2, 支持区分回放和下载
                                       //bySupport1 & 0x4, 是否支持布防优先级	
                                       //bySupport1 & 0x8, 智能设备是否支持布防时间段扩展
                                       //bySupport1 & 0x10, 表示是否支持多磁盘数（超过33个）
                                       //bySupport1 & 0x20, 表示是否支持rtsp over http	
                                       //bySupport1 & 0x80, 表示是否支持车牌新报警信息2012-9-28, 且还表示是否支持NET_DVR_IPPARACFG_V40结构体
        public byte bySupport2; /*能力，位与结果为0表示不支持，非0表示支持							
							bySupport2 & 0x1, 表示解码器是否支持通过URL取流解码
							bySupport2 & 0x2,  表示支持FTPV40
							bySupport2 & 0x4,  表示支持ANR
							bySupport2 & 0x8,  表示支持CCD的通道参数配置
							bySupport2 & 0x10,  表示支持布防报警回传信息（仅支持抓拍机报警 新老报警结构）
							bySupport2 & 0x20,  表示是否支持单独获取设备状态子项
							bySupport2 & 0x40,  表示是否是码流加密设备*/
        public ushort wDevType;              //设备型号
        public byte bySupport3; //能力集扩展，位与结果为0表示不支持，1表示支持
                                //bySupport3 & 0x1, 表示是否多码流
                                // bySupport3 & 0x4 表示支持按组配置， 具体包含 通道图像参数、报警输入参数、IP报警输入、输出接入参数、
                                // 用户参数、设备工作状态、JPEG抓图、定时和时间抓图、硬盘盘组管理 
                                //bySupport3 & 0x8为1 表示支持使用TCP预览、UDP预览、多播预览中的"延时预览"字段来请求延时预览（后续都将使用这种方式请求延时预览）。而当bySupport3 & 0x8为0时，将使用 "私有延时预览"协议。
                                //bySupport3 & 0x10 表示支持"获取报警主机主要状态（V40）"。
                                //bySupport3 & 0x20 表示是否支持通过DDNS域名解析取流

        public byte byMultiStreamProto;//是否支持多码流,按位表示,0-不支持,1-支持,bit1-码流3,bit2-码流4,bit7-主码流，bit-8子码流
        public byte byStartDChan;       //起始数字通道号,0表示无效
        public byte byStartDTalkChan;   //起始数字对讲通道号，区别于模拟对讲通道号，0表示无效
        public byte byHighDChanNum;     //数字通道个数，高位
        public byte bySupport4;
        public byte byLanguageType;// 支持语种能力,按位表示,每一位0-不支持,1-支持  
                                   //  byLanguageType 等于0 表示 老设备
                                   //  byLanguageType & 0x1表示支持中文
                                   //  byLanguageType & 0x2表示支持英文
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 9, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes2;       //保留
    }

    //球机位置信息
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_PTZPOS
    {
        public ushort wAction;//获取时该字段无效
        public ushort wPanPos;//水平参数
        public ushort wTiltPos;//垂直参数
        public ushort wZoomPos;//变倍参数
    }

    //图片质量
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_JPEGPARA
    {
        /*注意：当图像压缩分辨率为VGA时，支持0=CIF, 1=QCIF, 2=D1抓图，
        当分辨率为3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA,7=XVGA, 8=HD900p
        仅支持当前分辨率的抓图*/
        public ushort wPicSize;/* 0=CIF, 1=QCIF, 2=D1 3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA*/
        public ushort wPicQuality;/* 图片质量系数 0-最好 1-较好 2-一般 */
    }

    //视频参数配置
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_VIDEOEFFECT
    {
        public byte byBrightnessLevel; /*0-100*/
        public byte byContrastLevel; /*0-100*/
        public byte bySharpnessLevel; /*0-100*/
        public byte bySaturationLevel; /*0-100*/
        public byte byHueLevel; /*0-100,（保留）*/
        public byte byEnableFunc; //使能，按位表示，bit0-SMART IR(防过曝)，bit1-低照度,bit2-强光抑制使能，0-否，1-是
        public byte byLightInhibitLevel; //强光抑制等级，[1-3]表示等级
        public byte byGrayLevel; //灰度值域，0-[0-255]，1-[16-235]
    }

    //增益配置
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_GAIN
    {
        public byte byGainLevel; /*增益：0-100*/
        public byte byGainUserSet; /*用户自定义增益；0-100，对于抓拍机，是CCD模式下的抓拍增益*/
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 2, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;
        public uint dwMaxGainValue;/*最大增益值，单位dB*/
    }

    //白平衡配置
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_WHITEBALANCE
    {
        public byte byWhiteBalanceMode; /*0-手动白平衡（MWB）,1-自动白平衡1（AWB1）,2-自动白平衡2 (AWB2),3-自动控制改名为锁定白平衡(Locked WB)，
	                         4-室外(Indoor)，5-室内(Outdoor)6-日光灯(Fluorescent Lamp)，7-钠灯(Sodium Lamp)，
	                         8-自动跟踪(Auto-Track)9-一次白平衡(One Push)，10-室外自动(Auto-Outdoor)，
	                         11-钠灯自动 (Auto-Sodiumlight)，12-水银灯(Mercury Lamp)，13-自动白平衡(Auto)，
	                         14-白炽灯 (IncandescentLamp)，15-暖光灯(Warm Light Lamp)，16-自然光(Natural Light) */
        public byte byWhiteBalanceModeRGain; /*手动白平衡时有效，手动白平衡 R增益*/
        public byte byWhiteBalanceModeBGain; /*手动白平衡时有效，手动白平衡 B增益*/
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 5, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;
    }

    //曝光控制
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_EXPOSURE
    {
        public byte byExposureMode; /*0 手动曝光 1自动曝光*/
        public byte byAutoApertureLevel; /* 自动光圈灵敏度, 0-10 */
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 2, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;
        public uint dwVideoExposureSet; /* 自定义视频曝光时间（单位us）*//*注:自动曝光时该值为曝光最慢值 新增20-1s(1000000us)*/
        public uint dwExposureUserSet; /* 自定义曝光时间,在抓拍机上应用时，CCD模式时是抓拍快门速度*/
        public uint dwRes;
    }

    //宽动态配置
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_WDR
    {
        public byte byWDREnabled; /*宽动态：0 dsibale  1 enable 2 auto*/
        public byte byWDRLevel1; /*0-F*/
        public byte byWDRLevel2; /*0-F*/
        public byte byWDRContrastLevel; /*0-100*/
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 16, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;
    }

    //日夜转换功能配置
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_DAYNIGHT
    {
        public byte byDayNightFilterType; /*日夜切换：0-白天，1-夜晚，2-自动，3-定时，4-报警输入触发*/
        public byte bySwitchScheduleEnabled; /*0 dsibale  1 enable,(保留)*/
        //定时模式参数
        public byte byBeginTime; /*开始时间（小时），0-23*/
        public byte byEndTime; /*结束时间（小时），0-23*/
        //模式2
        public byte byDayToNightFilterLevel; //0-7
        public byte byNightToDayFilterLevel; //0-7
        public byte byDayNightFilterTime;//(60秒)
                                         //定时模式参数
        public byte byBeginTimeMin; //开始时间（分），0-59
        public byte byBeginTimeSec; //开始时间（秒），0-59
        public byte byEndTimeMin; //结束时间（分），0-59
        public byte byEndTimeSec; //结束时间（秒），0-59
                                  //报警输入触发模式参数
        public byte byAlarmTrigState; //报警输入触发状态，0-白天，1-夜晚
    }

    //Gamma校正
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_GAMMACORRECT
    {
        public byte byGammaCorrectionEnabled; /*0 dsibale  1 enable*/
        public byte byGammaCorrectionLevel; /*0-100*/
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 6, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;
    }

    //背光补偿配置
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_BACKLIGHT
    {
        public byte byBacklightMode; /*背光补偿:0 off 1 UP、2 DOWN、3 LEFT、4 RIGHT、5MIDDLE、6自定义*/
        public byte byBacklightLevel; /*0x0-0xF*/
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 2, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes1;
        public uint dwPositionX1; //（X坐标1）
        public uint dwPositionY1; //（Y坐标1）
        public uint dwPositionX2; //（X坐标2）
        public uint dwPositionY2; //（Y坐标2）
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 4, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes2;
    }

    //数字降噪功能
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_NOISEREMOVE
    {
        public byte byDigitalNoiseRemoveEnable; /*0-不启用，1-普通模式数字降噪，2-专家模式数字降噪*/
        public byte byDigitalNoiseRemoveLevel; /*普通模式数字降噪级别：0x0-0xF*/
        public byte bySpectralLevel;       /*专家模式下空域强度：0-100*/
        public byte byTemporalLevel;   /*专家模式下时域强度：0-100*/
        public byte byDigitalNoiseRemove2DEnable;         /* 抓拍帧2D降噪，0-不启用，1-启用 */
        public byte byDigitalNoiseRemove2DLevel;            /* 抓拍帧2D降噪级别，0-100 */
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 2, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;
    }

    //CMOS模式下前端镜头配置
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_CMOSMODECFG
    {
        public byte byCaptureMod;   //抓拍模式：0-抓拍模式1；1-抓拍模式2
        public byte byBrightnessGate;//亮度阈值
        public byte byCaptureGain1;   //抓拍增益1,0-100
        public byte byCaptureGain2;   //抓拍增益2,0-100
        public uint dwCaptureShutterSpeed1;//抓拍快门速度1
        public uint dwCaptureShutterSpeed2;//抓拍快门速度2
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 4, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;
    }

    //前端参数配置
    [StructLayoutAttribute(LayoutKind.Sequential)]
    public struct NET_DVR_CAMERAPARAMCFG
    {
        public uint dwSize;
        public NET_DVR_VIDEOEFFECT struVideoEffect;/*亮度、对比度、饱和度、锐度、色调配置*/
        public NET_DVR_GAIN struGain;/*自动增益*/
        public NET_DVR_WHITEBALANCE struWhiteBalance;/*白平衡*/
        public NET_DVR_EXPOSURE struExposure; /*曝光控制*/
        public NET_DVR_GAMMACORRECT struGammaCorrect;/*Gamma校正*/
        public NET_DVR_WDR struWdr;/*宽动态*/
        public NET_DVR_DAYNIGHT struDayNight;/*日夜转换*/
        public NET_DVR_BACKLIGHT struBackLight;/*背光补偿*/
        public NET_DVR_NOISEREMOVE struNoiseRemove;/*数字降噪*/
        public byte byPowerLineFrequencyMode; /*0-50HZ; 1-60HZ*/
        public byte byIrisMode; /*0 自动光圈 1手动光圈*/
        public byte byMirror;  /* 镜像：0 off，1- leftright，2- updown，3-center */
        public byte byDigitalZoom;  /*数字缩放:0 dsibale  1 enable*/
        public byte byDeadPixelDetect;   /*坏点检测,0 dsibale  1 enable*/
        public byte byBlackPwl;/*黑电平补偿 ,  0-255*/
        public byte byEptzGate;// EPTZ开关变量:0-不启用电子云台，1-启用电子云台
        public byte byLocalOutputGate;//本地输出开关变量0-本地输出关闭1-本地BNC输出打开 2-HDMI输出关闭  
                                      //20-HDMI_720P50输出开
                                      //21-HDMI_720P60输出开
                                      //22-HDMI_1080I60输出开
                                      //23-HDMI_1080I50输出开
                                      //24-HDMI_1080P24输出开
                                      //25-HDMI_1080P25输出开
                                      //26-HDMI_1080P30输出开
                                      //27-HDMI_1080P50输出开
                                      //28-HDMI_1080P60输出开
                                      //40-SDI_720P50,
                                      //41-SDI_720P60,
                                      //42-SDI_1080I50,
                                      //43-SDI_1080I60,
                                      //44-SDI_1080P24,
                                      //45-SDI_1080P25,
                                      //46-SDI_1080P30,
                                      //47-SDI_1080P50,
                                      //48-SDI_1080P60
        public byte byCoderOutputMode;//编码器fpga输出模式0直通3像素搬家
        public byte byLineCoding; //是否开启行编码：0-否，1-是
        public byte byDimmerMode; //调光模式：0-半自动，1-自动
        public byte byPaletteMode; //调色板：0-白热，1-黑热，2-调色板2，…，8-调色板8
        public byte byEnhancedMode; //增强方式（探测物体周边）：0-不增强，1-1，2-2，3-3，4-4
        public byte byDynamicContrastEN;    //动态对比度增强 0-1
        public byte byDynamicContrast;    //动态对比度 0-100
        public byte byJPEGQuality;    //JPEG图像质量 0-100
        public NET_DVR_CMOSMODECFG struCmosModeCfg;//CMOS模式下前端参数配置，镜头模式从能力集获取
        public byte byFilterSwitch; //滤波开关：0-不启用，1-启用
        public byte byFocusSpeed; //镜头调焦速度：0-10
        public byte byAutoCompensationInterval; //定时自动快门补偿：1-120，单位：分钟
        public byte bySceneMode;  //场景模式：0-室外，1-室内，2-默认，3-弱光
    }


    [StructLayout(LayoutKind.Sequential)]
    public struct NET_DVR_STD_CONFIG
    {
        public IntPtr lpCondBuffer;
        public uint dwCondSize;
        public IntPtr lpInBuffer;
        public uint dwInSize;
        public IntPtr lpOutBuffer;
        public uint dwOutSize;
        public IntPtr lpStatusBuffer;
        public uint dwStatusSize;
        public IntPtr lpXmlBuffer;
        public uint dwXmlSize;
        public byte byDataType;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 23, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct NET_DVR_STD_ABILITY
    {
        public IntPtr lpCondBuffer;    //[in]条件参数(码字格式),例如通道号等.可以为NULL
        public uint dwCondSize;        //[in] dwCondSize指向的内存大小
        public IntPtr lpOutBuffer;    //[out]输出参数(XML格式),不为NULL
        public uint dwOutSize;        //[in] lpOutBuffer指向的内存大小
        public IntPtr lpStatusBuffer;    //[out]返回的状态参数(XML格式),获取成功时不会赋值,如果不需要,可以置NULL
        public uint dwStatusSize;    //[in] lpStatusBuffer指向的内存大小
        public uint dwRetSize;        //[out]获取到的数据长度(lpOutBuffer或者lpStatusBuffer指向的实际数据长度)

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes;        //保留字节
    }


    public delegate void LOGINRESULTCALLBACK(int lUserID, int dwResult, IntPtr lpDeviceInfo, IntPtr pUser);
    [StructLayout(LayoutKind.Sequential)]
    public struct NET_DVR_USER_LOGIN_INFO
    {
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 129, ArraySubType = UnmanagedType.I1)]
        public byte[] sDeviceAddress;
        public byte byUseTransport;
        public ushort wPort;
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 64, ArraySubType = UnmanagedType.I1)]
        public byte[] sUserName;
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 64, ArraySubType = UnmanagedType.I1)]
        public byte[] sPassword;
        public LOGINRESULTCALLBACK cbLoginResult;
        public IntPtr pUser;
        public bool bUseAsynLogin;
        public byte byProxyType; //0:不使用代理，1：使用标准代理，2：使用EHome代理
        public byte byUseUTCTime;    //0-不进行转换，默认,1-接口上输入输出全部使用UTC时间,SDK完成UTC时间与设备时区的转换,2-接口上输入输出全部使用平台本地时间，SDK完成平台本地时间与设备时区的转换
        public byte byLoginMode; //0-Private, 1-ISAPI, 2-自适应
        public byte byHttps;    //0-不适用tls，1-使用tls 2-自适应
        public int iProxyID;    //代理服务器序号，添加代理服务器信息时，相对应的服务器数组下表值
        public byte byVerifyMode;  //认证方式，0-不认证，1-双向认证，2-单向认证；认证仅在使用TLS的时候生效;    
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 119, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes3;
    }
    [StructLayout(LayoutKind.Sequential)]
    public struct NET_DVR_DEVICEINFO_V40
    {
        public NET_DVR_DEVICEINFO_V30 struDeviceV30;
        public byte bySupportLock;        //设备支持锁定功能，该字段由SDK根据设备返回值来赋值的。bySupportLock为1时，dwSurplusLockTime和byRetryLoginTime有效
        public byte byRetryLoginTime;       //剩余可尝试登陆的次数，用户名，密码错误时，此参数有效
        public byte byPasswordLevel;      //admin密码安全等级0-无效，1-默认密码，2-有效密码,3-风险较高的密码。当用户的密码为出厂默认密码（12345）或者风险较高的密码时，上层客户端需要提示用户更改密码。      
        public byte byProxyType;//代理类型，0-不使用代理, 1-使用socks5代理, 2-使用EHome代理
        public uint dwSurplusLockTime;  //剩余时间，单位秒，用户锁定时，此参数有效
        public byte byCharEncodeType;     //字符编码类型
        public byte bySupportDev5;//支持v50版本的设备参数获取，设备名称和设备类型名称长度扩展为64字节
        public byte bySupport;  //能力集扩展，位与结果：0- 不支持，1- 支持
                                // bySupport & 0x1:  保留
                                // bySupport & 0x2:  0-不支持变化上报 1-支持变化上报
        public byte byLoginMode; //登录模式 0-Private登录 1-ISAPI登录
        public int dwOEMCode;
        public int iResidualValidity;   //该用户密码剩余有效天数，单位：天，返回负值，表示密码已经超期使用，例如“-3表示密码已经超期使用3天”
        public byte byResidualValidity; // iResidualValidity字段是否有效，0-无效，1-有效
        [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 243, ArraySubType = UnmanagedType.I1)]
        public byte[] byRes2;
    }

    [XmlRoot("SupplementLight", Namespace = "http://www.hikvision.com/ver20/XMLSchema")]
    public class SupplementLight
    {
        public enum SupplementMode { colorVuWhiteLight, close }
        public enum RegulatMode { auto, manual }

        [XmlAttribute("version")]
        public string version { get; set; }

        public SupplementMode supplementLightMode { get; set; }

        public RegulatMode mixedLightBrightnessRegulatMode { get; set; }

        public int whiteLightBrightness { get; set; }

        public int irLightBrightness { get; set; }
    }
}
